/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.v2.AuthToken;
import com.onyx.android.sdk.data.model.v2.BaseAuthAccount;
import com.onyx.android.sdk.data.model.v2.NeoAccountBase;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.StringUtils;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class LoginByAdminRequest
extends BaseCloudRequest {
    private BaseAuthAccount authAccount;
    private NeoAccountBase neoAccount;

    public LoginByAdminRequest(BaseAuthAccount authAccount) {
        this.authAccount = authAccount;
    }

    public NeoAccountBase getNeoAccount() {
        return this.neoAccount;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        this.neoAccount = this.loginToCloud(this.getContext(), parent);
    }

    private NeoAccountBase loginToCloud(Context context, CloudManager parent) throws Exception {
        AuthToken authToken = this.getAuthTokenFromCloud(context, parent);
        if (authToken == null || StringUtils.isNullOrEmpty((String)authToken.token)) {
            return null;
        }
        return this.getAccountInfoFromCloudImpl(parent, authToken);
    }

    private NeoAccountBase getAccountInfoFromCloudImpl(CloudManager parent, AuthToken authToken) throws Exception {
        NeoAccountBase account = null;
        Response<ResponseBody> response = this.executeCall(ServiceFactory.getContentService(parent.getCloudConf().getApiBase()).getAccount());
        if (response.isSuccessful()) {
            account = (NeoAccountBase)((Object)JSON.parseObject((String)((ResponseBody)response.body()).string(), NeoAccountBase.class));
            if (authToken != null) {
                account.setAuthToken(authToken.token, authToken.expires_in);
            }
            NeoAccountBase.parseName(account);
        }
        return account;
    }

    private AuthToken getAuthTokenFromCloud(Context context, CloudManager parent) throws Exception {
        if (this.authAccount == null) {
            return null;
        }
        AuthToken authToken = null;
        Response<AuthToken> response = this.executeCall(ServiceFactory.getContentService(parent.getCloudConf().getApiBase()).getAccountToken(this.authAccount));
        if (response.isSuccessful()) {
            authToken = (AuthToken)response.body();
            parent.setToken(authToken.token);
            this.updateTokenHeader(parent);
        }
        return authToken;
    }

    private void updateTokenHeader(CloudManager cloudManager) {
        if (StringUtils.isNotBlank((String)cloudManager.getToken())) {
            ServiceFactory.addRetrofitTokenHeader(cloudManager.getCloudConf().getApiBase(), "authorization", "Bearer " + cloudManager.getToken());
        }
    }
}

