/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.graphics.Bitmap;
import android.util.Log;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.common.DeviceInfoShowConfig;
import com.onyx.android.sdk.data.model.v2.NeoAccountBase;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.device.Device;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.StringUtils;

public class GenerateAccountInfoRequest
extends BaseCloudRequest {
    private NeoAccountBase authAccount;
    private DeviceInfoShowConfig infoShowConfig;

    public GenerateAccountInfoRequest(NeoAccountBase authAccount, DeviceInfoShowConfig infoShowConfig) {
        this.authAccount = authAccount;
        this.infoShowConfig = infoShowConfig;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        boolean needRotation = true;
        int rotationAngle = this.infoShowConfig == null ? 90 : this.infoShowConfig.rotationAngle;
        String targetString = this.authAccount.getName() + " " + this.authAccount.getFirstGroup();
        Bitmap bitmap = BitmapUtils.buildBitmapFromText((String)StringUtils.getBlankStr((String)targetString).trim(), (int)100, (int)25, (boolean)true, (boolean)true, (boolean)true, (boolean)needRotation, (int)rotationAngle, (String)"data/local/assets/info.png");
        if (this.infoShowConfig == null || bitmap == null) {
            Log.e((String)"GenerateAccountInfo", (String)"qrShowConfig or bitmap detects null");
            return;
        }
        int textWidth = needRotation ? bitmap.getHeight() : bitmap.getWidth();
        Device.currentDevice().setInfoShowConfig(this.infoShowConfig.orientation, this.infoShowConfig.startX, this.infoShowConfig.startY + (this.infoShowConfig.isScreenPositive() ? -textWidth : 0));
    }
}

