/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import android.graphics.Bitmap;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.v2.Course;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.RetrofitUtils;
import com.onyx.android.sdk.data.utils.ThumbnailUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.CollectionUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Response;

public class CourseImageRequest
extends BaseCloudRequest {
    private String courseImagePath;
    private boolean success = false;

    public CourseImageRequest(String savePath) {
        this.courseImagePath = savePath;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        List<Course> courseList = this.loadCourseListUrl(parent);
        if (CollectionUtils.isNullOrEmpty(courseList)) {
            return;
        }
        Bitmap bitmap = this.loadBitmapFromCloud(courseList.get((int)0).cfaFileUrl);
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        this.success = ThumbnailUtils.writeBitmapToThumbnailFile(new File(this.courseImagePath), bitmap);
    }

    private List<Course> loadCourseListUrl(CloudManager parent) {
        List<Course> courseList = new ArrayList<Course>();
        try {
            Response<List<Course>> response = RetrofitUtils.executeCall(ServiceFactory.getContentService(parent.getCloudConf().getApiBase()).getMyCourses());
            if (response.isSuccessful()) {
                courseList = (List)response.body();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return courseList;
    }

    private Bitmap loadBitmapFromCloud(String url) throws Exception {
        return (Bitmap)Glide.with((Context)this.getContext()).load(url).asBitmap().diskCacheStrategy(DiskCacheStrategy.SOURCE).into(Integer.MIN_VALUE, Integer.MIN_VALUE).get();
    }
}

