/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.bumptech.glide.Glide;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.cache.BitmapReferenceLruCache;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.manager.CacheManager;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.CloudUtils;
import com.onyx.android.sdk.data.utils.ThumbnailUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.io.File;
import java.io.IOException;

public class CloudThumbnailLoadRequest
extends BaseCloudRequest {
    private static final String TAG = CloudThumbnailLoadRequest.class.getSimpleName();
    private String coverUrl;
    private String associationId;
    private OnyxThumbnail.ThumbnailKind thumbnailKind = OnyxThumbnail.ThumbnailKind.Large;
    private CloseableReference<Bitmap> refBitmap;

    public CloudThumbnailLoadRequest(String coverUrl, String associateId) {
        this.coverUrl = coverUrl;
        this.associationId = associateId;
    }

    public CloudThumbnailLoadRequest(String coverUrl, String associateId, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        this(coverUrl, associateId);
        this.thumbnailKind = thumbnailKind;
    }

    public CloseableReference<Bitmap> getRefBitmap() {
        if (!this.isValid(this.refBitmap)) {
            return null;
        }
        return this.refBitmap.clone();
    }

    private boolean isValid(CloseableReference<Bitmap> bitmap) {
        return bitmap != null && bitmap.isValid();
    }

    private boolean isValid(Bitmap bitmap) {
        return bitmap != null && !bitmap.isRecycled();
    }

    @Override
    public void execute(CloudManager cloudManager) throws Exception {
        if (StringUtils.isNullOrEmpty((String)this.associationId)) {
            return;
        }
        if (this.loadFromMemoryCache(cloudManager) || this.isAbort()) {
            return;
        }
        if (this.loadFromCloud(cloudManager) || this.isAbort()) {
            return;
        }
        if (this.loadFromFileSystemCache(cloudManager) || this.isAbort()) {
            return;
        }
        this.loadFromDatabase(cloudManager);
    }

    private void saveToMemoryCache(CloudManager cloudManager) {
        cloudManager.getCacheManager().getBitmapLruCache().put(this.getCacheKey(), this.refBitmap);
    }

    private File thumbnailFileSystemCachePathWidthId() {
        return CloudUtils.imageCachePath(this.getContext(), this.associationId);
    }

    private boolean loadFromMemoryCache(CloudManager cloudManager) {
        BitmapReferenceLruCache lruCache = cloudManager.getCacheManager().getBitmapLruCache();
        this.refBitmap = (CloseableReference)lruCache.get(this.getCacheKey());
        return this.isValid(this.refBitmap);
    }

    private boolean loadFromFileSystemCache(CloudManager cloudManager) {
        File file = this.thumbnailFileSystemCachePathWidthId();
        if (file == null) {
            Log.w((String)TAG, (String)"detect associationId is null");
            return false;
        }
        if (file.exists() && file.length() > 0L && this.loadRefBitmap(file)) {
            this.saveToMemoryCache(cloudManager);
            return true;
        }
        return false;
    }

    private boolean loadFromDatabase(CloudManager cloudManager) {
        String path = this.loadThumbnailFilePathFromDatabase(this.getContext(), cloudManager.getCloudDataProvider(), this.associationId, this.thumbnailKind);
        if (StringUtils.isNullOrEmpty((String)path) || !FileUtils.fileExist((String)path)) {
            return false;
        }
        File file = new File(path);
        if (file.exists() && this.loadRefBitmap(file)) {
            this.saveToMemoryCache(cloudManager);
            return true;
        }
        return false;
    }

    private boolean loadFromCloud(CloudManager cloudManager) {
        if (!StringUtils.isUrl((String)this.coverUrl) || this.isAbort()) {
            return false;
        }
        Bitmap myBitmap = this.loadBitmapFromCloudImpl(this.coverUrl);
        if (!this.isValid(myBitmap) || this.isAbort()) {
            return false;
        }
        File file = this.thumbnailFileSystemCachePathWidthId();
        if (!this.writeBitmapToFile(file, myBitmap) || this.isAbort()) {
            return false;
        }
        if (this.loadRefBitmap(file)) {
            this.saveToMemoryCache(cloudManager);
        }
        return true;
    }

    private boolean writeBitmapToFile(File file, Bitmap originBitmap) {
        Bitmap newBitmap = originBitmap;
        if (this.thumbnailKind != OnyxThumbnail.ThumbnailKind.Original) {
            newBitmap = ThumbnailUtils.createLargeThumbnail(originBitmap);
        }
        return ThumbnailUtils.writeBitmapToThumbnailFile(file, newBitmap);
    }

    private boolean loadRefBitmap(File file) {
        boolean success = true;
        try {
            CloseableReference<Bitmap> bitmap = ThumbnailUtils.decodeFile(file);
            if (this.isValid(bitmap)) {
                this.refBitmap = bitmap.clone();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    private Bitmap loadBitmapFromCloudImpl(String url) {
        if (this.thumbnailKind == OnyxThumbnail.ThumbnailKind.Original) {
            return this.loadOriginBitmapFromCloudImpl(url);
        }
        return this.loadLargeBitmapFromCloudImpl(url);
    }

    private Bitmap loadLargeBitmapFromCloudImpl(String url) {
        try {
            return (Bitmap)Glide.with((Context)this.getContext()).load(url).asBitmap().fitCenter().into(512, 512).get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Bitmap loadOriginBitmapFromCloudImpl(String url) {
        try {
            return (Bitmap)Glide.with((Context)this.getContext()).load(url).asBitmap().into(Integer.MIN_VALUE, Integer.MIN_VALUE).get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void saveToThumbnail(CloudManager cloudManager, File file, Bitmap bitmap) {
        boolean hasThumbnail = ThumbnailUtils.hasThumbnail(this.getContext(), cloudManager.getCloudDataProvider(), this.associationId);
        DatabaseWrapper database = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        database.beginTransaction();
        if (!hasThumbnail) {
            ThumbnailUtils.insertThumbnail(this.getContext(), cloudManager.getCloudDataProvider(), file.getAbsolutePath(), this.associationId, this.thumbnailKind, bitmap);
        } else {
            ThumbnailUtils.updateThumbnailEntry(this.getContext(), cloudManager.getCloudDataProvider(), this.associationId, this.thumbnailKind, bitmap);
        }
        database.setTransactionSuccessful();
        database.endTransaction();
    }

    @Override
    public String getIdentifier() {
        return "cloudThumbnail";
    }

    private String loadThumbnailFilePathFromDatabase(Context context, DataProviderBase dataProvider, String associationId, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        Thumbnail thumbnail = dataProvider.getThumbnailEntry(context, associationId, thumbnailKind);
        if (thumbnail == null) {
            return null;
        }
        return thumbnail.getImageDataPath();
    }

    private String getCacheKey() {
        return CacheManager.generateCloudThumbnailKey(this.associationId, this.coverUrl);
    }
}

