/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import com.alibaba.fastjson.parser.Feature;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.common.ContentException;
import com.onyx.android.sdk.data.db.table.EduAccountProvider;
import com.onyx.android.sdk.data.model.v2.IndexService;
import com.onyx.android.sdk.data.provider.SystemConfigProvider;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.CloudConf;
import com.onyx.android.sdk.data.utils.JSONObjectParseUtils;
import com.onyx.android.sdk.data.utils.RetrofitUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.TestUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import retrofit2.Response;

public class CloudIndexServiceRequest
extends BaseCloudRequest {
    private volatile String apiBase;
    private IndexService requestService;
    private IndexService resultService;
    private int localRetryCount = 1;

    public CloudIndexServiceRequest(String base, IndexService service) {
        this.requestService = service;
        this.apiBase = base;
    }

    public IndexService getResultIndexService() {
        return this.resultService;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        this.resultService = this.loadContentServiceInfoFromLocal(this.getContext(), this.localRetryCount);
        IndexService cloudService = this.loadContentServiceInfoFromCloud(parent);
        if (cloudService != null && !cloudService.equals((Object)this.resultService)) {
            this.onContentServerChanged(parent, cloudService);
        }
        if (this.resultService != null && this.resultService.server != null) {
            String host = this.resultService.server.getServerHost();
            String api = this.resultService.server.getApiBase();
            parent.setAllCloudConf(CloudConf.create(host, api, "oss"));
            parent.setCloudDataProvider(parent.getCloudConf());
        }
    }

    private void clearAccountDb() {
        try {
            FlowManager.getContext().getContentResolver().delete(EduAccountProvider.CONTENT_URI, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onContentServerChanged(CloudManager parent, IndexService newIndexService) {
        this.clearAccountDb();
        parent.setToken(null);
        this.resultService = newIndexService;
        this.saveContentServiceInfo(this.getContext(), this.resultService);
    }

    private IndexService loadContentServiceInfoFromLocal(Context context, int retryCount) {
        IndexService service = null;
        for (int i = 0; i < retryCount && (service = this.loadContentServiceInfoFromLocalImpl(context)) == null; ++i) {
            if (retryCount <= 1) continue;
            TestUtils.sleep((long)300L);
        }
        return service;
    }

    private IndexService loadContentServiceInfoFromLocalImpl(Context context) {
        String value = SystemConfigProvider.getStringValue(context, "sys.content_server_info");
        return JSONObjectParseUtils.parseObject(value, IndexService.class, new Feature[0]);
    }

    private IndexService loadContentServiceInfoFromCloud(CloudManager parent) throws Exception {
        block3: {
            try {
                Response<IndexService> response = RetrofitUtils.executeCall(ServiceFactory.getContentService(this.apiBase).getIndexService(this.requestService.mac, this.requestService.installationId));
                if (response.isSuccessful()) {
                    return (IndexService)((Object)response.body());
                }
            }
            catch (Exception e) {
                if (!ContentException.isCloudException(e)) break block3;
                this.processCloudException(parent, (ContentException)e);
            }
        }
        return null;
    }

    private void processCloudException(CloudManager parent, ContentException cloudException) {
        cloudException.printStackTrace();
        if (cloudException.isCloudNotFound()) {
            this.onContentServerChanged(parent, null);
        }
    }

    private void saveContentServiceInfo(Context context, IndexService contentService) {
        SystemConfigProvider.setStringValue(context, "sys.content_server_info", JSONObjectParseUtils.toJson((Object)contentService));
    }

    public void setLocalLoadRetryCount(int retryCount) {
        if (retryCount <= 0) {
            return;
        }
        this.localRetryCount = retryCount;
    }
}

