/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.v2.CloudGroup;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.RetrofitUtils;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Response;

public class CloudGroupListRequest
extends BaseCloudRequest {
    private List<CloudGroup> myGroupList;

    public List<CloudGroup> getMyGroupList() {
        return this.myGroupList;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        this.myGroupList = this.fetchFromCloud(parent);
    }

    private List<CloudGroup> fetchFromCloud(CloudManager parent) {
        ArrayList<CloudGroup> list = new ArrayList();
        try {
            Response<List<CloudGroup>> response = RetrofitUtils.executeCall(ServiceFactory.getContentService(parent.getCloudConf().getApiBase()).getMyGroupList());
            if (response.isSuccessful()) {
                list = (List)response.body();
                this.saveToLocalDatabase(list);
            }
        }
        catch (Exception e) {
            list = this.fetchFromLocal();
        }
        return list;
    }

    private List<CloudGroup> fetchFromLocal() {
        return StoreUtils.queryDataList(CloudGroup.class);
    }

    private void saveToLocalDatabase(List<CloudGroup> list) {
        try {
            StoreUtils.saveToLocal(list, CloudGroup.class, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

