/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.manager.CacheManager;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.common.FetchPolicy;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.utils.CollectionUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CloudContentRefreshRequest
extends BaseCloudRequest {
    private QueryArgs queryArgs;
    private QueryResult<Library> libraryResult;
    private QueryResult<Metadata> queryResult;
    private Map<String, CloseableReference<Bitmap>> thumbnailBitmap = new HashMap<String, CloseableReference<Bitmap>>();

    public CloudContentRefreshRequest(QueryArgs queryArgs) {
        this.queryArgs = queryArgs;
    }

    public QueryResult<Metadata> getProductResult() {
        return this.queryResult;
    }

    public QueryResult<Library> getLibraryResult() {
        return this.libraryResult;
    }

    @Override
    public void execute(CloudManager cloudManager) throws Exception {
        this.checkQueryCloudPolicy(this.queryArgs);
        this.libraryResult = this.loadLibraryQueryResult(cloudManager);
        this.queryResult = DataManagerHelper.cloudMetadataFromDataProvider(this.getContext(), cloudManager.getCloudDataProvider(), this.queryArgs);
        if (this.queryResult == null || this.queryResult.hasException()) {
            return;
        }
        this.deleteCollectionSetByLibraryId(this.getContext(), cloudManager.getCloudDataProvider(), this.queryArgs.libraryUniqueId);
        if (this.queryResult.isContentEmpty()) {
            this.clearMetadataCache(cloudManager.getCacheManager(), this.queryArgs);
            return;
        }
        this.updateMetadataCache(cloudManager.getCacheManager(), this.queryArgs, this.queryResult);
        DataManagerHelper.saveCloudMetadataAndCollection(this.getContext(), cloudManager.getCloudDataProvider(), this.queryArgs, this.queryResult);
        this.thumbnailBitmap = DataManagerHelper.loadCloudThumbnailBitmapsWithCache(this.getContext(), cloudManager, this.queryResult.list);
    }

    private void checkQueryCloudPolicy(QueryArgs queryArgs) {
        if (!FetchPolicy.isCloudOnlyPolicy(queryArgs.fetchPolicy)) {
            queryArgs.useCloudOnlyPolicy();
        }
    }

    private QueryResult<Library> loadLibraryQueryResult(CloudManager parent) {
        QueryResult<Library> queryResult = new QueryResult<Library>();
        queryResult.list = DataManagerHelper.fetchLibraryLibraryList(this.getContext(), parent.getCloudDataProvider(), this.queryArgs);
        queryResult.count = CollectionUtils.getSize(queryResult.list);
        return queryResult;
    }

    private void deleteCollectionSetByLibraryId(Context context, DataProviderBase dataProvider, String libraryId) {
        dataProvider.deleteMetadataCollection(context, libraryId);
    }

    private void updateMetadataCache(CacheManager cacheManager, QueryArgs queryArgs, QueryResult<Metadata> result) {
        List<Metadata> cacheList = Arrays.asList(new Metadata[(int)result.count]);
        cacheManager.addToMetadataCache(CacheManager.generateCloudKey(queryArgs), cacheList);
        DataManagerHelper.updateCloudCacheList(cacheList, result, queryArgs);
    }

    private void clearMetadataCache(CacheManager cacheManager, QueryArgs queryArgs) {
        cacheManager.clearMetadataCache(CacheManager.generateCloudKey(queryArgs));
    }

    public Map<String, CloseableReference<Bitmap>> getThumbnailMap() {
        return this.thumbnailBitmap;
    }
}

