/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.manager.CacheManager;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.common.FetchPolicy;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CloudContentListRequest
extends BaseCloudRequest {
    private static final String TAG = CloudContentListRequest.class.getSimpleName();
    private boolean loadThumbnail = true;
    private boolean saveToLocal = true;
    private QueryResult<Metadata> queryResult;
    private QueryArgs queryArgs;
    private Map<String, CloseableReference<Bitmap>> thumbnailBitmap = new HashMap<String, CloseableReference<Bitmap>>();

    public CloudContentListRequest(QueryArgs queryArgs) {
        this.queryArgs = queryArgs;
    }

    public CloudContentListRequest(QueryArgs queryArgs, boolean saveToLocal) {
        this(queryArgs);
        this.saveToLocal = saveToLocal;
    }

    public QueryArgs getQueryArgs() {
        return this.queryArgs;
    }

    public QueryResult<Metadata> getProductResult() {
        return this.queryResult;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        this.queryResult = this.loadQueryResult(this.getContext(), parent, this.queryArgs);
        if (this.loadThumbnail && this.isValidQueryResult(this.queryResult)) {
            this.thumbnailBitmap = DataManagerHelper.loadCloudThumbnailBitmapsWithCache(this.getContext(), parent, this.queryResult.list);
        }
    }

    private QueryResult<Metadata> loadQueryResult(Context context, CloudManager cloudManager, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult = new QueryResult<Metadata>();
        if (FetchPolicy.isMemPartPolicy(queryArgs.fetchPolicy) && this.checkMemoryCache(cloudManager.getCacheManager(), queryArgs, queryResult)) {
            return queryResult;
        }
        queryResult = this.loadFromDataProvider(context, cloudManager, queryArgs);
        this.updateMetadataCache(cloudManager.getCacheManager(), queryArgs, queryResult);
        this.saveToLocal(cloudManager.getCloudDataProvider(), queryArgs, queryResult);
        return this.buildRequireResult(queryResult, queryArgs);
    }

    private QueryResult<Metadata> buildRequireResult(QueryResult<Metadata> originResult, QueryArgs args) {
        QueryResult<Metadata> result = new QueryResult<Metadata>();
        if (!this.isValidQueryResult(originResult)) {
            return result;
        }
        result = originResult.copy(this.queryArgs.limit);
        return result;
    }

    private boolean checkMemoryCache(CacheManager cacheManager, QueryArgs queryArgs, QueryResult<Metadata> result) {
        List<Metadata> cacheList = cacheManager.getMetadataLruCache(this.getQueryKey(queryArgs));
        if (cacheList == null) {
            return false;
        }
        return DataManagerHelper.cloudMetadataFromCache(result, queryArgs, cacheList);
    }

    private QueryResult<Metadata> loadFromDataProvider(Context context, CloudManager cloudManager, QueryArgs queryArgs) {
        return DataManagerHelper.cloudMetadataFromDataProvider(context, cloudManager.getCloudDataProvider(), queryArgs);
    }

    private boolean isValidQueryResult(QueryResult result) {
        return result != null && !result.isContentEmpty();
    }

    private void updateMetadataCache(CacheManager cacheManager, QueryArgs queryArgs, QueryResult<Metadata> result) {
        List<Metadata> cacheList = this.getMetadataCache(cacheManager, this.getQueryKey(queryArgs), (int)result.count);
        DataManagerHelper.updateCloudCacheList(cacheList, result, queryArgs);
    }

    private List<Metadata> getMetadataCache(CacheManager cacheManager, String queryKey, int contentCount) {
        List<Metadata> cacheList = cacheManager.getMetadataLruCache(queryKey);
        if (contentCount > CollectionUtils.getSize(cacheList)) {
            Metadata[] array = new Metadata[contentCount];
            cacheList = Arrays.asList(array);
            cacheManager.addToMetadataCache(queryKey, cacheList);
        }
        return cacheList;
    }

    private String getQueryKey(QueryArgs args) {
        return CacheManager.generateCloudKey(args);
    }

    private void saveToLocal(DataProviderBase dataProvider, QueryArgs queryArgs, QueryResult<Metadata> queryResult) {
        if (!(this.saveToLocal && this.isValidQueryResult(queryResult) && queryResult.isFetchFromCloud())) {
            return;
        }
        if (StringUtils.isNullOrEmpty((String)queryArgs.libraryUniqueId)) {
            Log.w((String)TAG, (String)"detect libraryId is NULL");
            Log.w((String)TAG, (String)"saveCollection method may delete collection associated with NULL libraryId");
        }
        DatabaseWrapper database = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        database.beginTransaction();
        for (Metadata metadata : queryResult.list) {
            dataProvider.saveMetadata(this.getContext(), metadata);
            this.saveCollection(this.getContext(), dataProvider, queryArgs.libraryUniqueId, metadata.getAssociationId());
        }
        database.setTransactionSuccessful();
        database.endTransaction();
    }

    public Map<String, CloseableReference<Bitmap>> getThumbnailMap() {
        return this.thumbnailBitmap;
    }

    public void setLoadThumbnail(boolean loadThumbnail) {
        this.loadThumbnail = loadThumbnail;
    }

    private void saveCollection(Context context, DataProviderBase dataProvider, String libraryId, String associationId) {
        DataManagerHelper.saveCloudCollection(context, dataProvider, libraryId, associationId);
    }
}

