/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.v2.CloudContentImportList;
import com.onyx.android.sdk.data.model.v2.CloudMetadata;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.JSONObjectParseUtils;
import com.onyx.android.sdk.data.utils.ThumbnailUtils;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.ArrayList;
import java.util.List;

public class CloudContentImportFromJsonRequest
extends BaseCloudRequest {
    private static final String TAG = CloudContentImportFromJsonRequest.class.getSimpleName();
    private List<String> filePathList = new ArrayList<String>();

    public CloudContentImportFromJsonRequest(List<String> filePathList) {
        this.filePathList = filePathList;
    }

    @Override
    public void execute(CloudManager cloudManager) throws Exception {
        if (CollectionUtils.isNullOrEmpty(this.filePathList)) {
            return;
        }
        for (String path : this.filePathList) {
            if (StringUtils.isNullOrEmpty((String)path) || !FileUtils.fileExist((String)path)) continue;
            List<CloudContentImportList> contentImportList = JSONObjectParseUtils.parseObject(StringUtils.getBlankStr((String)FileUtils.readContentOfFile((String)path)), new TypeReference<List<CloudContentImportList>>(){}, new Feature[0]);
            if (contentImportList == null || CollectionUtils.isNullOrEmpty(contentImportList)) {
                Log.w((String)TAG, (String)"detect contentImportList is empty");
                continue;
            }
            for (CloudContentImportList contentImport : contentImportList) {
                if (contentImport == null || CollectionUtils.isNullOrEmpty(contentImport.metadataList)) continue;
                this.importToDatabase(this.getContext(), cloudManager, FileUtils.getParent((String)path), contentImport);
            }
        }
    }

    private void importToDatabase(Context context, CloudManager cloudManager, String parentPath, CloudContentImportList contentImport) {
        DataProviderBase dataProvider = cloudManager.getCloudDataProvider();
        DatabaseWrapper database = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        database.beginTransaction();
        Library library = this.saveLibrary(context, dataProvider, contentImport.library);
        for (Metadata metadata : contentImport.metadataList) {
            boolean success;
            String fileName = FileUtils.getFileNameFromUrl((String)metadata.getLocation());
            if (StringUtils.isNotBlank((String)fileName)) {
                metadata.setNativeAbsolutePath(parentPath + "/" + fileName);
            }
            String thumbnailPath = null;
            String thumbnailFileName = FileUtils.getFileNameFromUrl((String)metadata.getCoverUrl());
            if (StringUtils.isNotBlank((String)thumbnailFileName)) {
                thumbnailPath = parentPath + "/" + thumbnailFileName;
            }
            if (!(success = this.saveMetadata(context, dataProvider, metadata))) continue;
            this.saveCloudCollection(context, dataProvider, library, metadata.getAssociationId());
            this.saveThumbnail(context, dataProvider, metadata.getAssociationId(), metadata.getNativeAbsolutePath(), thumbnailPath);
        }
        database.setTransactionSuccessful();
        database.endTransaction();
    }

    private boolean saveMetadata(Context context, DataProviderBase dataProvider, Metadata metadata) {
        if (StringUtils.isNullOrEmpty((String)metadata.getNativeAbsolutePath())) {
            return false;
        }
        if (!FileUtils.fileExist((String)metadata.getNativeAbsolutePath())) {
            return false;
        }
        if ((metadata = CloudMetadata.createFromMetadataPath(metadata, true)) == null) {
            return false;
        }
        dataProvider.saveMetadata(context, metadata);
        return true;
    }

    private Library saveLibrary(Context context, DataProviderBase dataProvider, Library library) {
        if (library == null || StringUtils.isNullOrEmpty((String)library.getIdString()) || StringUtils.isNullOrEmpty((String)library.getName())) {
            return null;
        }
        dataProvider.addLibrary(library);
        return library;
    }

    private void saveThumbnail(Context context, DataProviderBase dataProvider, String associationId, String filePath, String thumbnailPath) {
        if (StringUtils.isNullOrEmpty((String)thumbnailPath) || StringUtils.isNullOrEmpty((String)associationId)) {
            return;
        }
        if (!FileUtils.fileExist((String)thumbnailPath)) {
            return;
        }
        Bitmap bitmap = BitmapUtils.loadBitmapFromFile((String)thumbnailPath);
        if (bitmap == null) {
            return;
        }
        ThumbnailUtils.insertThumbnail(context, dataProvider, filePath, associationId, bitmap);
    }

    private void saveCloudCollection(Context context, DataProviderBase dataProvider, Library library, String associationId) {
        if (library == null || StringUtils.isNullOrEmpty((String)library.getIdString())) {
            return;
        }
        DataManagerHelper.saveCloudCollection(context, dataProvider, library.getIdString(), associationId);
    }
}

