/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.v2.InstallationIdBinding;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.NetworkUtil;
import com.onyx.android.sdk.utils.StringUtils;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class BindingInfoSaveRequest
extends BaseCloudRequest {
    private InstallationIdBinding infoBinding;
    private boolean resultSuccess;

    public BindingInfoSaveRequest(InstallationIdBinding binding) {
        this.infoBinding = binding;
    }

    public boolean isResultSuccess() {
        return this.resultSuccess;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        this.bindInstallationIdByMac(this.getContext(), parent);
    }

    private void bindInstallationIdByMac(Context context, CloudManager parent) throws Exception {
        if (!NetworkUtil.isWiFiConnected((Context)context) || !this.infoBinding.checkBindingInfoValid()) {
            return;
        }
        String macAddress = NetworkUtil.getMacAddress((Context)context);
        if (StringUtils.isNullOrEmpty((String)macAddress)) {
            return;
        }
        Response<ResponseBody> response = this.executeCall(ServiceFactory.getContentService(parent.getCloudConf().getApiBase()).updateInstallationIdByMac(this.infoBinding));
        this.resultSuccess = response.isSuccessful();
    }
}

