/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import android.os.Handler;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.common.request.BaseRequest;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.JsonRespone;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.ProgressRequestBody;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.DeviceUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.NetworkUtil;
import java.io.File;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Response;

public class UploadBackupFileRequest
extends BaseCloudRequest {
    private String backupFilePath;
    private boolean cleanup = true;

    public UploadBackupFileRequest(String backupFilePath, boolean c) {
        this.backupFilePath = backupFilePath;
        this.cleanup = c;
    }

    @Override
    public void execute(final CloudManager parent) throws Exception {
        File dbFile = new File(this.backupFilePath);
        String md5 = FileUtils.computeFullMD5Checksum((File)dbFile);
        String name = DeviceUtils.getApplicationName((Context)this.getContext());
        String packageName = DeviceUtils.getPackageName((Context)this.getContext());
        String version = DeviceUtils.getPackageVersionName((Context)this.getContext());
        String mac = NetworkUtil.getMacAddress((Context)this.getContext());
        ProgressRequestBody requestBody = new ProgressRequestBody(dbFile, "form-data", new ProgressRequestBody.UploadCallbacks(){

            @Override
            public void onProgressUpdate(int percentage) {
                BaseCallback.ProgressInfo progressInfo = new BaseCallback.ProgressInfo();
                progressInfo.progress = percentage;
                BaseCallback.invokeProgress((Handler)parent.getRequestManager().getLooperHandler(), (BaseCallback)UploadBackupFileRequest.this.getCallback(), (BaseRequest)UploadBackupFileRequest.this, (BaseCallback.ProgressInfo)progressInfo);
            }

            @Override
            public void onError() {
            }

            @Override
            public void onFinish() {
            }
        });
        MultipartBody.Part fileBody = MultipartBody.Part.createFormData((String)"file", (String)dbFile.getName(), (RequestBody)requestBody);
        MultipartBody.Part md5Body = MultipartBody.Part.createFormData((String)"md5", (String)md5);
        MultipartBody.Part nameBody = MultipartBody.Part.createFormData((String)"name", (String)name);
        MultipartBody.Part packageBody = MultipartBody.Part.createFormData((String)"package", (String)packageName);
        MultipartBody.Part versionBody = MultipartBody.Part.createFormData((String)"version", (String)version);
        MultipartBody.Part macBody = MultipartBody.Part.createFormData((String)"deviceMAC", (String)mac);
        Response<JsonRespone> responseCall = this.executeCall(ServiceFactory.getBackupService(parent.getCloudConf().getApiBase()).uploadBackupFile(fileBody, nameBody, packageBody, versionBody, md5Body, macBody));
        if (responseCall != null && !responseCall.isSuccessful()) {
            throw new Exception(responseCall.message());
        }
        if (this.cleanup) {
            FileUtils.deleteFile((String)this.backupFilePath);
        }
    }
}

