/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.dataprovider.R;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.NetworkUtil;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class SaveDocumentDataToCloudRequest
extends BaseCloudRequest {
    private String uploadDBPath;
    private Context context;
    private String fileFullMd5;
    private String cloudDocId;
    private String token;
    private String errorMessage;

    public SaveDocumentDataToCloudRequest(String uploadDBPath, Context context, String fileFullMd5, String cloudDocId, String token) {
        this.uploadDBPath = uploadDBPath;
        this.context = context;
        this.fileFullMd5 = fileFullMd5;
        this.cloudDocId = cloudDocId;
        this.token = token;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (!FileUtils.fileExist((String)this.uploadDBPath)) {
            this.errorMessage = this.getContext().getString(R.string.no_find_upload_database_file);
            return;
        }
        if (!NetworkUtil.isWiFiConnected((Context)this.context)) {
            this.errorMessage = this.getContext().getString(R.string.network_not_connected);
            return;
        }
        if (StringUtils.isNullOrEmpty((String)this.fileFullMd5)) {
            this.errorMessage = this.getContext().getString(R.string.empty_md5);
            return;
        }
        if (StringUtils.isNullOrEmpty((String)this.cloudDocId)) {
            this.errorMessage = this.getContext().getString(R.string.empty_cloud_documentId);
            return;
        }
        this.updateTokenHeader(parent);
        File dbFile = new File(this.uploadDBPath);
        RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"form-data"), (File)dbFile);
        MultipartBody.Part fileBody = MultipartBody.Part.createFormData((String)"file", (String)dbFile.getName(), (RequestBody)requestFile);
        MultipartBody.Part md5Body = MultipartBody.Part.createFormData((String)"md5", (String)this.fileFullMd5);
        MultipartBody.Part docIdBody = MultipartBody.Part.createFormData((String)"docId", (String)this.cloudDocId);
        try {
            this.executeCall(ServiceFactory.getSyncService(parent.getCloudConf().getApiBase()).pushReaderData(fileBody, md5Body, docIdBody));
        }
        catch (Exception e) {
            this.errorMessage = this.getContext().getString(R.string.network_request_exception);
            e.printStackTrace();
        }
    }

    private void updateTokenHeader(CloudManager cloudManager) {
        if (StringUtils.isNotBlank((String)this.token)) {
            ServiceFactory.addRetrofitTokenHeader(cloudManager.getCloudConf().getApiBase(), "authorization", "Bearer " + this.token);
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

