/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import com.onyx.android.sdk.data.StatisticsCloudManager;
import com.onyx.android.sdk.data.model.JsonRespone;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel;
import com.onyx.android.sdk.data.request.cloud.BaseStatisticsRequest;
import com.onyx.android.sdk.data.utils.StatisticsUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.NetworkUtil;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.List;
import retrofit2.Response;

public class PushStatisticsRequest
extends BaseStatisticsRequest {
    private static final int MAX_PUSH_COUNT = 1000;
    private Context context;
    private List<OnyxStatisticsModel> saveStatistic;
    private String url;

    public PushStatisticsRequest(Context context, List<OnyxStatisticsModel> statistic, String url) {
        this.context = context;
        this.saveStatistic = statistic;
        this.url = url;
    }

    @Override
    public void execute(StatisticsCloudManager parent) throws Exception {
        if (this.saveStatistic != null) {
            StatisticsUtils.saveStatisticsList(this.context, this.saveStatistic);
        }
        if (StringUtils.isNullOrEmpty((String)this.url)) {
            return;
        }
        if (!NetworkUtil.isWiFiConnected((Context)this.context)) {
            return;
        }
        String mac = NetworkUtil.getMacAddress((Context)this.context);
        if (StringUtils.isNullOrEmpty((String)mac)) {
            return;
        }
        List statisticsModels = (List)StatisticsUtils.loadStatisticsListByStatus(this.context, 1000, 0);
        if (statisticsModels == null || statisticsModels.size() <= 0) {
            return;
        }
        this.updateStatisticsMac(statisticsModels, mac);
        Response<JsonRespone> response = null;
        try {
            response = this.executeCall(ServiceFactory.getStatisticsService(this.url).pushStatistics(statisticsModels));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (response != null && response.isSuccessful()) {
            for (OnyxStatisticsModel model : statisticsModels) {
                model.setStatus(1);
            }
            StatisticsUtils.saveStatisticsList(this.context, statisticsModels);
        }
    }

    private void updateStatisticsMac(List<OnyxStatisticsModel> statistics, String mac) {
        for (OnyxStatisticsModel onyxStatisticsModel : statistics) {
            onyxStatisticsModel.setMac(mac);
        }
    }
}

