/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.AppProduct;
import com.onyx.android.sdk.data.model.ProductQuery;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import java.util.List;
import retrofit2.Response;

public class MarketAppListRequest
extends BaseCloudRequest {
    private ProductQuery query;
    private List<AppProduct> productList;

    public MarketAppListRequest(ProductQuery query) {
        this.query = query;
    }

    public List<AppProduct> getProductList() {
        return this.productList;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (CloudManager.isWifiConnected(this.getContext())) {
            this.fetchFromCloud(parent);
        } else {
            this.fetchFromLocalCache(parent);
        }
    }

    private void fetchFromLocalCache(CloudManager parent) throws Exception {
        this.productList = StoreUtils.queryDataList(AppProduct.class);
    }

    private void fetchFromCloud(CloudManager parent) throws Exception {
        Response<ProductResult<AppProduct>> response = this.executeCall(ServiceFactory.getOTAService(parent.getCloudConf().getApiBase()).getMarketAppList(JSON.toJSONString((Object)this.query)));
        if (response.isSuccessful()) {
            this.productList = ((ProductResult)response.body()).list;
            StoreUtils.saveToLocal(this.productList, AppProduct.class, true);
        }
    }
}

