/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.support.annotation.NonNull;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.manager.OssManager;
import com.onyx.android.sdk.data.model.Device;
import com.onyx.android.sdk.data.model.Firmware;
import com.onyx.android.sdk.data.model.LogCollection;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.DeviceInfoUtil;
import com.onyx.android.sdk.utils.LogUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Locale;
import retrofit2.Response;

public class LogCollectionRequest
extends BaseCloudRequest {
    private String uploadFileUrl;
    private OssManager ossManager;
    private String desc;

    public LogCollectionRequest(@NonNull OssManager ossManager, String desc) {
        this.ossManager = ossManager;
        this.desc = desc;
    }

    public String getUploadFileUrl() {
        return this.uploadFileUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CloudManager parent) throws Exception {
        File zipFile = LogUtils.generateFeedBackFile((Context)this.getContext());
        if (zipFile == null || !zipFile.exists()) {
            throw new FileNotFoundException();
        }
        try {
            String objectKey = this.ossManager.syncUploadFile(this.getContext(), zipFile.getAbsolutePath());
            if (StringUtils.isNullOrEmpty((String)objectKey)) {
                return;
            }
            this.reportFeedbackInfo(parent, objectKey);
        }
        catch (Exception e) {
            this.setException(e);
        }
        finally {
            zipFile.delete();
        }
    }

    private void reportFeedbackInfo(CloudManager parent, String objectKey) throws Exception {
        String fileUrl = this.ossManager.getOssEndPoint() + File.separator + objectKey;
        Firmware firmware = this.getCurrentFirmware();
        LogCollection logCollection = new LogCollection();
        logCollection.firmware = firmware;
        logCollection.desc = this.desc;
        logCollection.zipFile = fileUrl;
        Response response = ServiceFactory.getLogService(parent.getCloudConf().getApiBase()).reportLogCollection(logCollection).execute();
        if (response.isSuccessful()) {
            this.uploadFileUrl = fileUrl;
        }
    }

    private Firmware getCurrentFirmware() {
        Point point = DeviceInfoUtil.getScreenResolution((Context)this.getContext());
        Firmware firmware = Firmware.currentFirmware();
        firmware.buildDisplayId = Build.DISPLAY;
        firmware.lang = Locale.getDefault().toString();
        firmware.widthPixels = point.x;
        firmware.heightPixels = point.y;
        Device device = Device.updateCurrentDeviceInfo(this.getContext());
        if (device != null) {
            firmware.deviceMAC = device.macAddress;
        }
        return firmware;
    }
}

