/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.JsonResponse;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.StringUtils;
import retrofit2.Response;

public class GetDocumentDataFromCloudRequest
extends BaseCloudRequest {
    private String cloudDocId;
    private String token;
    private String errorMessage;
    private String documentData;

    public GetDocumentDataFromCloudRequest(String cloudDocId, String token) {
        this.cloudDocId = cloudDocId;
        this.token = token;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (StringUtils.isNullOrEmpty((String)this.cloudDocId)) {
            this.errorMessage = "cloud document id is empty";
            return;
        }
        if (StringUtils.isNullOrEmpty((String)this.token)) {
            this.errorMessage = "token is empty";
            return;
        }
        this.updateTokenHeader(parent, this.token);
        try {
            Response<JsonResponse> response = this.executeCall(ServiceFactory.getSyncService(parent.getCloudConf().getApiBase()).getDocumentData(this.cloudDocId));
            if (response != null) {
                this.documentData = ((JsonResponse)response.body()).data;
            }
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            e.printStackTrace();
        }
    }

    public String getDocumentData() {
        return this.documentData;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void updateTokenHeader(CloudManager parent, String token) {
        if (StringUtils.isNotBlank((String)token)) {
            ServiceFactory.addRetrofitTokenHeader(parent.getCloudConf().getApiBase(), "authorization", "Bearer " + token);
        }
    }
}

