/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.GAdapter;
import com.onyx.android.sdk.data.model.Dictionary;
import com.onyx.android.sdk.data.model.DictionaryQuery;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.CloudUtils;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import retrofit2.Call;
import retrofit2.Response;

public class DictionaryListRequest
extends BaseCloudRequest {
    private static final String TAG = DictionaryListRequest.class.getSimpleName();
    private DictionaryQuery dictionaryQuery;
    private ProductResult<Dictionary> productResult;
    private GAdapter adapter;
    private volatile boolean clearCache;
    private volatile boolean cloudOnly;

    public DictionaryListRequest(DictionaryQuery query, boolean clear, boolean cloud) {
        this.dictionaryQuery = query;
        this.clearCache = clear;
        this.cloudOnly = cloud;
    }

    public final ProductResult<Dictionary> getProductResult() {
        return this.productResult;
    }

    public final GAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (CloudManager.isWifiConnected(this.getContext())) {
            this.fetchFromCloud(parent);
        } else if (!this.cloudOnly) {
            this.fetchFromLocalCache(parent);
        }
        this.adapter = CloudUtils.adapterFromDictionaryResult(this.getContext(), this.productResult, Integer.MAX_VALUE, parent.getCloudConf());
    }

    public void fetchFromLocalCache(CloudManager parent) throws Exception {
        this.productResult = new ProductResult();
        this.productResult.list = SQLite.select((IProperty[])new IProperty[0]).from(Dictionary.class).queryList();
        this.productResult.count = this.productResult.list.size();
    }

    public void fetchFromCloud(CloudManager parent) throws Exception {
        Call<ProductResult<Dictionary>> call = ServiceFactory.getDictionaryService(parent.getCloudConf().getApiBase()).dictionaryList(JSON.toJSONString((Object)this.dictionaryQuery));
        Response<ProductResult<Dictionary>> response = this.executeCall(call);
        if (response.isSuccessful()) {
            this.productResult = (ProductResult)response.body();
            if (this.isSaveToLocal()) {
                StoreUtils.saveToLocal(this.productResult, Dictionary.class, this.clearCache);
            }
        }
    }
}

