/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.Category;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.v1.OnyxBookStoreService;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.StringUtils;
import retrofit2.Response;

public class ContainerRequest
extends BaseCloudRequest {
    private Category category;
    private String id;

    public ContainerRequest(String categoryId) {
        this.id = categoryId;
    }

    public Category getCategory() {
        return this.category;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (StringUtils.isNullOrEmpty((String)this.id)) {
            throw new Exception("categoryId is blank");
        }
        this.fetchFromCloud(parent);
    }

    public void fetchFromCloud(CloudManager parent) throws Exception {
        OnyxBookStoreService service = ServiceFactory.getBookStoreService(parent.getCloudConf().getApiBase());
        Response<Category> response = this.executeCall(service.bookContainer(this.id));
        if (response.isSuccessful()) {
            this.category = (Category)((Object)response.body());
        }
    }
}

