/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import android.util.Pair;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.common.request.BaseRequest;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class CloudRequestChain {
    private boolean abortException = true;
    private List<Pair<BaseCloudRequest, BaseCallback>> pairList = new ArrayList<Pair<BaseCloudRequest, BaseCallback>>();

    public CloudRequestChain addRequest(BaseCloudRequest request, BaseCallback callback) {
        this.addRequestCallBackPair((Pair<BaseCloudRequest, BaseCallback>)new Pair((Object)request, (Object)callback));
        return this;
    }

    public CloudRequestChain addRequestCallBackPair(Pair<BaseCloudRequest, BaseCallback> pair) {
        this.pairList.add(pair);
        return this;
    }

    public void execute(final Context context, final CloudManager manager) {
        if (this.isFinished()) {
            return;
        }
        final Pair<BaseCloudRequest, BaseCallback> pair = this.pairList.remove(0);
        this.executeRequest(context, manager, (BaseCloudRequest)((Object)pair.first), new BaseCallback(){

            public void done(BaseRequest request, Throwable e) {
                BaseCallback.invoke((BaseCallback)((BaseCallback)pair.second), (BaseRequest)request, (Throwable)e);
                if (CloudRequestChain.this.abortException && e != null) {
                    return;
                }
                CloudRequestChain.this.execute(context, manager);
            }
        });
    }

    private void executeRequest(Context context, CloudManager manager, BaseCloudRequest request, BaseCallback callback) {
        manager.submitRequest(context, request, callback);
    }

    public boolean isFinished() {
        return CollectionUtils.isNullOrEmpty(this.pairList);
    }

    public void clearChainList() {
        if (this.isFinished()) {
            return;
        }
        this.pairList.clear();
    }

    public boolean isAbortException() {
        return this.abortException;
    }

    public CloudRequestChain setAbortException(boolean abort) {
        this.abortException = abort;
        return this;
    }
}

