/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.OnyxAccount;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.StringUtils;
import retrofit2.Call;
import retrofit2.Response;

public class AccountUpdateRequest
extends BaseCloudRequest {
    private OnyxAccount updateAccount;

    public AccountUpdateRequest(OnyxAccount updateAccount) {
        this.updateAccount = updateAccount;
    }

    public OnyxAccount getUpdateAccount() {
        return this.updateAccount;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (StringUtils.isNullOrEmpty((String)this.updateAccount.email)) {
            throw new Exception("email is blank");
        }
        Call<OnyxAccount> call = ServiceFactory.getAccountService(parent.getCloudConf().getApiBase()).updateAccountInfo(this.updateAccount, this.getAccountSessionToken());
        Response<OnyxAccount> response = this.executeCall(call);
        if (response.isSuccessful()) {
            this.updateAccount = (OnyxAccount)((Object)response.body());
            this.updateAccount.sessionToken = this.getAccountSessionToken();
        }
    }
}

