/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.provider;

import android.content.Context;
import android.net.Uri;
import com.onyx.android.sdk.data.db.table.OnyxSystemConfigProvider;
import com.onyx.android.sdk.data.model.v2.SystemKeyValueItem;
import com.onyx.android.sdk.data.model.v2.SystemKeyValueItem_Table;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.provider.ContentUtils;

public class SystemConfigProvider {
    public static final int INT_INVALID = -1;
    public static final String KEY_CONTENT_SERVER_INFO = "sys.content_server_info";

    public static String getStringValue(Context context, String key) {
        SystemKeyValueItem item = SystemConfigProvider.queryKeyValueItem(context, key);
        return item == null ? null : item.value;
    }

    public static boolean setStringValue(Context context, String key, String value) {
        return SystemConfigProvider.addKeyValueItem(context, SystemKeyValueItem.create(key, value));
    }

    public static boolean setIntValue(Context context, String key, int value) {
        return SystemConfigProvider.setStringValue(context, key, String.valueOf(value));
    }

    public static int getIntValue(Context context, String key) {
        String value = SystemConfigProvider.getStringValue(context, key);
        if (value == null) {
            return -1;
        }
        return SystemConfigProvider.parseInteger(value);
    }

    public static boolean getBooleanValue(Context context, String key) {
        String value = SystemConfigProvider.getStringValue(context, key);
        if (value == null) {
            return false;
        }
        return SystemConfigProvider.parseBoolean(value);
    }

    public static boolean setBooleanValue(Context context, String key, boolean value) {
        return SystemConfigProvider.setStringValue(context, key, String.valueOf(value));
    }

    public static SystemKeyValueItem queryKeyValueItem(Context context, String key) {
        try {
            return (SystemKeyValueItem)ContentUtils.querySingle((Uri)OnyxSystemConfigProvider.CONTENT_URI, SystemKeyValueItem.class, (ConditionGroup)ConditionGroup.clause().and((SQLCondition)SystemKeyValueItem_Table.key.eq((Object)key)), null, (String[])new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean addKeyValueItem(Context context, SystemKeyValueItem item) {
        Uri uri;
        item.beforeSave();
        SystemKeyValueItem findItem = SystemConfigProvider.queryKeyValueItem(context, item.key);
        long result = 0L;
        result = findItem == null || !findItem.hasValidId() ? ((uri = ContentUtils.insert((Uri)OnyxSystemConfigProvider.CONTENT_URI, (Model)item)) == null || StringUtils.isNullOrEmpty((String)uri.getLastPathSegment()) ? -1L : SystemConfigProvider.parseLong(uri.getLastPathSegment())) : (long)ContentUtils.update((Uri)OnyxSystemConfigProvider.CONTENT_URI, (Model)item);
        if (result > 0L) {
            item.setId(result);
        }
        return result > 0L;
    }

    public static boolean delete(Context context, SystemKeyValueItem item) {
        int rowNumber = ContentUtils.delete((Uri)OnyxSystemConfigProvider.CONTENT_URI, (Model)item);
        return rowNumber > 0;
    }

    private static int parseInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static long parseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private static boolean parseBoolean(String value) {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return false;
        }
    }
}

