/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.provider;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.db.table.OnyxAnnotationProvider;
import com.onyx.android.sdk.data.db.table.OnyxBookmarkProvider;
import com.onyx.android.sdk.data.db.table.OnyxLibraryProvider;
import com.onyx.android.sdk.data.db.table.OnyxMetadataCollectionProvider;
import com.onyx.android.sdk.data.db.table.OnyxMetadataProvider;
import com.onyx.android.sdk.data.db.table.OnyxThumbnailProvider;
import com.onyx.android.sdk.data.model.Annotation;
import com.onyx.android.sdk.data.model.Annotation_Table;
import com.onyx.android.sdk.data.model.Bookmark;
import com.onyx.android.sdk.data.model.Bookmark_Table;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Library_Table;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.MetadataCollection_Table;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.model.Thumbnail_Table;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.utils.MetadataUtils;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.provider.ContentUtils;
import java.io.File;
import java.util.List;

public class RemoteDataProvider
implements DataProviderBase {
    private static final String TAG = RemoteDataProvider.class.getSimpleName();

    @Override
    public void clearMetadata() {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataProvider.CONTENT_URI, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Metadata findMetadataByIdString(Context context, String idString) {
        Metadata metadata = null;
        try {
            metadata = (Metadata)ContentUtils.querySingle((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (ConditionGroup)ConditionGroup.clause().and((SQLCondition)Metadata_Table.idString.eq((Object)idString)), null, (String[])new String[0]);
        }
        catch (Exception exception) {
            return MetadataUtils.ensureObject(metadata);
            catch (Throwable throwable) {
                return MetadataUtils.ensureObject(metadata);
            }
        }
        return MetadataUtils.ensureObject(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Metadata findMetadataByPath(Context context, String path) {
        Metadata metadata = null;
        try {
            metadata = (Metadata)ContentUtils.querySingle((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (ConditionGroup)ConditionGroup.clause().and((SQLCondition)Metadata_Table.nativeAbsolutePath.eq((Object)path)), null, (String[])new String[0]);
        }
        catch (Exception exception) {
            return MetadataUtils.ensureObject(metadata);
            catch (Throwable throwable) {
                return MetadataUtils.ensureObject(metadata);
            }
        }
        return MetadataUtils.ensureObject(metadata);
    }

    @Override
    public void saveMetadata(Context context, Metadata metadata) {
        metadata.beforeSave();
        Metadata findMeta = this.findMetadataByHashTag(context, metadata.getNativeAbsolutePath(), metadata.getHashTag());
        if (!findMeta.hasValidId()) {
            ContentUtils.insert((Uri)OnyxMetadataProvider.CONTENT_URI, (Model)metadata);
        } else {
            ContentUtils.update((Uri)OnyxMetadataProvider.CONTENT_URI, (Model)metadata);
        }
    }

    @Override
    public QueryResult<Metadata> findMetadataResultByQueryArgs(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> result = new QueryResult<Metadata>();
        result.list = this.findMetadataByQueryArgs(context, queryArgs);
        result.count = this.count(context, queryArgs);
        return result;
    }

    @Override
    public List<Metadata> findMetadataByQueryArgs(Context context, QueryArgs queryArgs) {
        return ContentUtils.queryList((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (ConditionGroup)queryArgs.conditionGroup, (String)queryArgs.getOrderByQueryWithLimitOffset(), (String[])queryArgs.getProjectionSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Metadata findMetadataByHashTag(Context context, String path, String hashTag) {
        Metadata metadata = null;
        try {
            if (StringUtils.isNullOrEmpty((String)hashTag)) {
                hashTag = FileUtils.computeMD5((File)new File(path));
            }
            metadata = (Metadata)ContentUtils.querySingle((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (ConditionGroup)ConditionGroup.clause().or((SQLCondition)Metadata_Table.hashTag.eq((Object)hashTag)).or((SQLCondition)Metadata_Table.nativeAbsolutePath.eq((Object)path)), null, (String[])new String[0]);
        }
        catch (Exception exception) {
            return MetadataUtils.ensureObject(metadata);
            catch (Throwable throwable) {
                return MetadataUtils.ensureObject(metadata);
            }
        }
        return MetadataUtils.ensureObject(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(Context context, QueryArgs queryArgs) {
        Cursor cursor;
        block3: {
            long l;
            cursor = null;
            try {
                cursor = FlowManager.getContext().getContentResolver().query(OnyxMetadataProvider.CONTENT_URI, queryArgs.getProjectionSet(), queryArgs.conditionGroup.getQuery(), null, null);
                if (cursor != null) break block3;
                Log.w((String)TAG, (String)"queryArgs count cursor null");
                l = 0L;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(cursor);
                throw throwable;
            }
            FileUtils.closeQuietly((Cursor)cursor);
            return l;
        }
        long l = cursor.getCount();
        FileUtils.closeQuietly((Cursor)cursor);
        return l;
    }

    @Override
    public void removeMetadata(Context context, Metadata metadata) {
        ContentUtils.delete((Uri)OnyxMetadataProvider.CONTENT_URI, (Model)metadata);
    }

    @Override
    public boolean saveDocumentOptions(Context context, String path, String associationId, String json) {
        try {
            Metadata document = this.findMetadataByHashTag(context, path, associationId);
            document.setExtraAttributes(json);
            document.beforeSave();
            if (!document.hasValidId()) {
                document.setHashTag(associationId);
                ContentUtils.insert((Uri)OnyxMetadataProvider.CONTENT_URI, (Model)document);
            } else {
                ContentUtils.update((Uri)OnyxMetadataProvider.CONTENT_URI, (Model)document);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Annotation> loadAnnotations(String application, String associationId, int pageNumber, OrderBy orderBy) {
        ConditionGroup conditionGroup = ConditionGroup.clause().and((SQLCondition)Annotation_Table.idString.eq((Object)associationId)).and((SQLCondition)Annotation_Table.application.eq((Object)application)).and((SQLCondition)Annotation_Table.pageNumber.eq(pageNumber));
        return ContentUtils.queryList((Uri)OnyxAnnotationProvider.CONTENT_URI, Annotation.class, (ConditionGroup)conditionGroup, (String)orderBy.getQuery(), (String[])new String[0]);
    }

    @Override
    public List<Annotation> loadAnnotations(String application, String associationId, OrderBy orderBy) {
        ConditionGroup conditionGroup = ConditionGroup.clause().and((SQLCondition)Annotation_Table.idString.eq((Object)associationId)).and((SQLCondition)Annotation_Table.application.eq((Object)application));
        return ContentUtils.queryList((Uri)OnyxAnnotationProvider.CONTENT_URI, Annotation.class, (ConditionGroup)conditionGroup, (String)orderBy.getQuery(), (String[])new String[0]);
    }

    @Override
    public void addAnnotation(Annotation annotation) {
        annotation.beforeSave();
        ContentUtils.insert((Uri)OnyxAnnotationProvider.CONTENT_URI, (Model)annotation);
    }

    @Override
    public void updateAnnotation(Annotation annotation) {
        annotation.beforeSave();
        ContentUtils.update((Uri)OnyxAnnotationProvider.CONTENT_URI, (Model)annotation);
    }

    @Override
    public void deleteAnnotation(Annotation annotation) {
        ContentUtils.delete((Uri)OnyxAnnotationProvider.CONTENT_URI, (Model)annotation);
    }

    @Override
    public Bookmark loadBookmark(String application, String associationId, int pageNumber) {
        ConditionGroup conditionGroup = ConditionGroup.clause().and((SQLCondition)Bookmark_Table.idString.eq((Object)associationId)).and((SQLCondition)Bookmark_Table.application.eq((Object)application)).and((SQLCondition)Bookmark_Table.pageNumber.eq(pageNumber));
        return (Bookmark)ContentUtils.querySingle((Uri)OnyxBookmarkProvider.CONTENT_URI, Bookmark.class, (ConditionGroup)conditionGroup, null, (String[])new String[0]);
    }

    @Override
    public List<Bookmark> loadBookmarks(String application, String associationId, OrderBy orderBy) {
        ConditionGroup conditionGroup = ConditionGroup.clause().and((SQLCondition)Bookmark_Table.idString.eq((Object)associationId)).and((SQLCondition)Bookmark_Table.application.eq((Object)application));
        return ContentUtils.queryList((Uri)OnyxBookmarkProvider.CONTENT_URI, Bookmark.class, (ConditionGroup)conditionGroup, (String)orderBy.getQuery(), (String[])new String[0]);
    }

    @Override
    public void addBookmark(Bookmark bookmark) {
        bookmark.beforeSave();
        ContentUtils.insert((Uri)OnyxBookmarkProvider.CONTENT_URI, (Model)bookmark);
    }

    @Override
    public void deleteBookmark(Bookmark bookmark) {
        ContentUtils.delete((Uri)OnyxBookmarkProvider.CONTENT_URI, (Model)bookmark);
    }

    private Condition getNullOrEqualCondition(Property<String> property, String compare) {
        return compare == null ? property.isNull() : property.eq((Object)compare);
    }

    private Condition getNotNullOrEqualCondition(Property<String> property, String compare) {
        return compare == null ? property.isNotNull() : property.eq((Object)compare);
    }

    @Override
    public Library loadLibrary(String uniqueId) {
        return (Library)ContentUtils.querySingle((Uri)OnyxLibraryProvider.CONTENT_URI, Library.class, (ConditionGroup)ConditionGroup.clause().and((SQLCondition)Library_Table.idString.eq((Object)uniqueId)), null, (String[])new String[0]);
    }

    @Override
    public QueryResult<Library> fetchAllLibrary(String parentId, QueryArgs queryArgs) {
        QueryResult<Library> result = new QueryResult<Library>();
        result.list = this.loadAllLibrary(parentId, queryArgs);
        result.count = CollectionUtils.getSize(result.list);
        return result;
    }

    @Override
    public List<Library> loadAllLibrary(String parentId, QueryArgs queryArgs) {
        Condition condition = this.getNullOrEqualCondition(Library_Table.parentUniqueId, queryArgs.libraryUniqueId);
        return ContentUtils.queryList((Uri)OnyxLibraryProvider.CONTENT_URI, Library.class, (ConditionGroup)ConditionGroup.clause().and((SQLCondition)condition), null, (String[])new String[0]);
    }

    @Override
    public void addLibrary(Library library) {
        library.beforeSave();
        ContentUtils.insert((Uri)OnyxLibraryProvider.CONTENT_URI, (Model)library);
    }

    @Override
    public void updateLibrary(Library library) {
        library.beforeSave();
        ContentUtils.update((Uri)OnyxLibraryProvider.CONTENT_URI, (Model)library);
    }

    @Override
    public void deleteLibrary(Library library) {
        ContentUtils.delete((Uri)OnyxLibraryProvider.CONTENT_URI, (Model)library);
    }

    @Override
    public void clearLibrary() {
        FlowManager.getContext().getContentResolver().delete(OnyxLibraryProvider.CONTENT_URI, null, null);
    }

    @Override
    public void clearThumbnails() {
        FlowManager.getContext().getContentResolver().delete(OnyxThumbnailProvider.CONTENT_URI, null, null);
    }

    @Override
    public void saveThumbnailEntry(Context context, Thumbnail thumbnail) {
        thumbnail.beforeSave();
        Thumbnail findThumbnail = this.getThumbnailEntry(context, thumbnail.getIdString(), thumbnail.getThumbnailKind());
        if (findThumbnail == null || !findThumbnail.hasValidId()) {
            ContentUtils.insert((Uri)OnyxThumbnailProvider.CONTENT_URI, (Model)thumbnail);
        } else {
            ContentUtils.update((Uri)OnyxThumbnailProvider.CONTENT_URI, (Model)thumbnail);
        }
    }

    @Override
    public Thumbnail getThumbnailEntry(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        ConditionGroup group = ConditionGroup.clause().and((SQLCondition)Thumbnail_Table.idString.eq((Object)associationId)).and((SQLCondition)Thumbnail_Table.thumbnailKind.eq((Object)kind));
        return (Thumbnail)ContentUtils.querySingle((ContentResolver)context.getContentResolver(), (Uri)OnyxThumbnailProvider.CONTENT_URI, Thumbnail.class, (ConditionGroup)group, null, (String[])new String[0]);
    }

    @Override
    public void deleteThumbnailEntry(Thumbnail thumbnail) {
        ContentUtils.delete((Uri)OnyxThumbnailProvider.CONTENT_URI, (Model)thumbnail);
    }

    @Override
    public boolean saveThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap saveBitmap) {
        return false;
    }

    @Override
    public boolean removeThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        ConditionGroup group = ConditionGroup.clause().and((SQLCondition)Thumbnail_Table.idString.eq((Object)associationId)).and((SQLCondition)Thumbnail_Table.thumbnailKind.eq((Object)kind));
        int row = FlowManager.getContext().getContentResolver().delete(OnyxThumbnailProvider.CONTENT_URI, group.getQuery(), null);
        return row != 0;
    }

    @Override
    public Bitmap getThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        Thumbnail thumbnail = this.getThumbnailEntry(context, associationId, kind);
        if (thumbnail == null || StringUtils.isNullOrEmpty((String)thumbnail.getImageDataPath())) {
            return null;
        }
        return BitmapUtils.loadBitmapFromFile((String)thumbnail.getImageDataPath());
    }

    public List<Thumbnail> loadThumbnail(Context context, String associationId) {
        ConditionGroup group = ConditionGroup.clause().and((SQLCondition)Thumbnail_Table.idString.eq((Object)associationId));
        return ContentUtils.queryList((ContentResolver)context.getContentResolver(), (Uri)OnyxThumbnailProvider.CONTENT_URI, Thumbnail.class, (ConditionGroup)group, null, (String[])new String[0]);
    }

    @Override
    public void clearMetadataCollection() {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, null, null);
    }

    @Override
    public void addMetadataCollection(Context context, MetadataCollection collection) {
        collection.beforeSave();
        ContentUtils.insert((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, (Model)collection);
    }

    @Override
    public void deleteMetadataCollection(Context context, String libraryUniqueId, String associationId) {
        ConditionGroup group = ConditionGroup.clause().and((SQLCondition)MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId));
        if (StringUtils.isNotBlank((String)associationId)) {
            group.and((SQLCondition)MetadataCollection_Table.documentUniqueId.eq((Object)associationId));
        }
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, group.getQuery(), null);
    }

    @Override
    public void deleteMetadataCollection(Context context, String libraryUniqueId) {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, ConditionGroup.clause().and((SQLCondition)MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)).getQuery(), null);
    }

    @Override
    public void deleteMetadataCollectionByDocId(Context context, String docId) {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, ConditionGroup.clause().and((SQLCondition)MetadataCollection_Table.documentUniqueId.eq((Object)docId)).getQuery(), null);
    }

    @Override
    public void updateMetadataCollection(MetadataCollection collection) {
        collection.beforeSave();
        ContentUtils.update((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, (Model)collection);
    }

    @Override
    public MetadataCollection loadMetadataCollection(Context context, String libraryUniqueId, String associationId) {
        ConditionGroup group = ConditionGroup.clause().and((SQLCondition)MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)).and((SQLCondition)MetadataCollection_Table.documentUniqueId.eq((Object)associationId));
        return (MetadataCollection)ContentUtils.querySingle((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, MetadataCollection.class, (ConditionGroup)group, null, (String[])new String[0]);
    }

    @Override
    public List<MetadataCollection> loadMetadataCollection(Context context, String libraryUniqueId) {
        ConditionGroup group = ConditionGroup.clause().and((SQLCondition)MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId));
        return ContentUtils.queryList((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, MetadataCollection.class, (ConditionGroup)group, null, (String[])new String[0]);
    }

    @Override
    public MetadataCollection findMetadataCollection(Context context, String associationId) {
        ConditionGroup group = ConditionGroup.clause().and((SQLCondition)MetadataCollection_Table.documentUniqueId.eq((Object)associationId));
        return (MetadataCollection)ContentUtils.querySingle((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, MetadataCollection.class, (ConditionGroup)group, null, (String[])new String[0]);
    }
}

