/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.provider;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.common.ContentException;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.converter.QueryArgsFilter;
import com.onyx.android.sdk.data.model.Annotation;
import com.onyx.android.sdk.data.model.Bookmark;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.model.Thumbnail_Table;
import com.onyx.android.sdk.data.model.common.FetchPolicy;
import com.onyx.android.sdk.data.model.v2.CloudLibrary;
import com.onyx.android.sdk.data.model.v2.CloudLibrary_Table;
import com.onyx.android.sdk.data.model.v2.CloudMetadata;
import com.onyx.android.sdk.data.model.v2.CloudMetadataCollection;
import com.onyx.android.sdk.data.model.v2.CloudMetadataCollection_Table;
import com.onyx.android.sdk.data.model.v2.CloudMetadata_Table;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.utils.CloudConf;
import com.onyx.android.sdk.data.utils.MetadataUtils;
import com.onyx.android.sdk.data.utils.RetrofitUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.data.v2.ContentService;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.NetworkUtil;
import com.raizlabs.android.dbflow.sql.language.Delete;
import com.raizlabs.android.dbflow.sql.language.Method;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import retrofit2.Response;

public class CloudDataProvider
implements DataProviderBase {
    private static final String TAG = CloudDataProvider.class.getSimpleName();
    private CloudConf conf;

    public CloudDataProvider(CloudConf conf) {
        this.conf = conf;
    }

    public void setCloudConf(CloudConf cloudConf) {
        this.conf = cloudConf;
    }

    @Override
    public void clearMetadata() {
        Delete.table(CloudMetadata.class, (SQLCondition[])new SQLCondition[0]);
    }

    @Override
    public void saveMetadata(Context context, Metadata metadata) {
        metadata.beforeSave();
        Metadata findMeta = this.findMetadataByCloudId(metadata.getCloudId());
        metadata.setId(findMeta.getId());
        metadata.save();
    }

    private Metadata findMetadataByCloudId(String cloudId) {
        Metadata metadata = (Metadata)new Select(new IProperty[0]).from(CloudMetadata.class).where(new SQLCondition[]{CloudMetadata_Table.cloudId.eq((Object)cloudId)}).querySingle();
        return MetadataUtils.ensureObject(metadata);
    }

    private List<Metadata> findMetadataFromLocalByQueryArgs(Context context, QueryArgs queryArgs) {
        if (queryArgs.conditionGroup != null) {
            Where where = new Select(queryArgs.propertyList.toArray(new IProperty[0])).from(CloudMetadata.class).where(new SQLCondition[]{queryArgs.conditionGroup});
            for (OrderBy orderBy : queryArgs.orderByList) {
                where.orderBy(orderBy);
            }
            List cloudList = where.offset(queryArgs.offset).limit(queryArgs.limit).queryList();
            ArrayList<Metadata> list = new ArrayList<Metadata>();
            for (CloudMetadata cloudMetadata : cloudList) {
                list.add(cloudMetadata);
            }
            return list;
        }
        return new ArrayList<Metadata>();
    }

    private long countMetadataFromLocal(Context context, QueryArgs queryArgs) {
        return new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(CloudMetadata.class).where(new SQLCondition[]{queryArgs.conditionGroup}).count();
    }

    private QueryResult<Metadata> fetchFromLocal(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> result = new QueryResult<Metadata>();
        result.list = this.findMetadataFromLocalByQueryArgs(context, queryArgs);
        result.count = this.countMetadataFromLocal(context, queryArgs);
        result.fetchSource = Metadata.FetchSource.LOCAL;
        return result;
    }

    private QueryResult<Metadata> fetchFromCloud(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> result;
        block4: {
            result = new QueryResult<Metadata>();
            try {
                Response<ProductResult<CloudMetadata>> response = RetrofitUtils.executeCall(this.getContentService().loadBookList(queryArgs.libraryUniqueId, JSON.toJSONString((Object)queryArgs, (SerializeFilter)new QueryArgsFilter(), (SerializerFeature[])new SerializerFeature[0])));
                if (response.isSuccessful()) {
                    result.list = new ArrayList();
                    for (Metadata metadata : ((ProductResult)response.body()).list) {
                        result.list.add(metadata);
                    }
                    result.count = ((ProductResult)response.body()).count;
                    result.fetchSource = Metadata.FetchSource.CLOUD;
                }
                this.checkCloudMetadataResult(result);
            }
            catch (Exception e) {
                result.setException(ContentException.createException(e));
                if (FetchPolicy.isCloudOnlyPolicy(queryArgs.fetchPolicy) || FetchPolicy.isMemDbCloudPolicy(queryArgs.fetchPolicy)) break block4;
                result = this.fetchFromLocal(context, queryArgs);
            }
        }
        return result;
    }

    private void checkCloudMetadataResult(QueryResult<Metadata> result) {
        if (result == null || result.count <= 0L || CollectionUtils.isNullOrEmpty(result.list)) {
            Log.w((String)TAG, (String)"detect cloud metadata is empty");
        }
    }

    @Override
    public QueryResult<Metadata> findMetadataResultByQueryArgs(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> result;
        if (FetchPolicy.isCloudPartPolicy(queryArgs.fetchPolicy)) {
            result = this.fetchFromCloud(context, queryArgs);
        } else {
            result = this.fetchFromLocal(context, queryArgs);
            if (FetchPolicy.isMemDbCloudPolicy(queryArgs.fetchPolicy) && result.isContentEmpty()) {
                result = this.fetchFromCloud(context, queryArgs);
            }
        }
        return result;
    }

    @Override
    public List<Metadata> findMetadataByQueryArgs(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> result = this.findMetadataResultByQueryArgs(context, queryArgs);
        return result.list;
    }

    @Override
    public Metadata findMetadataByIdString(Context context, String idString) {
        return null;
    }

    @Override
    public Metadata findMetadataByPath(Context context, String path) {
        return null;
    }

    @Override
    public Metadata findMetadataByHashTag(Context context, String path, String hashTag) {
        return null;
    }

    @Override
    public long count(Context context, QueryArgs queryArgs) {
        long count = NetworkUtil.isWiFiConnected((Context)context) ? this.findMetadataResultByQueryArgs((Context)context, (QueryArgs)queryArgs).count : this.countMetadataFromLocal(context, queryArgs);
        return count;
    }

    @Override
    public void removeMetadata(Context context, Metadata metadata) {
        metadata.delete();
    }

    @Override
    public boolean saveDocumentOptions(Context context, String path, String associationId, String json) {
        return false;
    }

    @Override
    public List<Annotation> loadAnnotations(String application, String associationId, int pageNumber, OrderBy orderBy) {
        return null;
    }

    @Override
    public List<Annotation> loadAnnotations(String application, String associationId, OrderBy orderBy) {
        return null;
    }

    @Override
    public void addAnnotation(Annotation annotation) {
    }

    @Override
    public void updateAnnotation(Annotation annotation) {
    }

    @Override
    public void deleteAnnotation(Annotation annotation) {
    }

    @Override
    public Bookmark loadBookmark(String application, String associationId, int pageNumber) {
        return null;
    }

    @Override
    public List<Bookmark> loadBookmarks(String application, String associationId, OrderBy orderBy) {
        return null;
    }

    @Override
    public void addBookmark(Bookmark bookmark) {
    }

    @Override
    public void deleteBookmark(Bookmark bookmark) {
    }

    @Override
    public Library loadLibrary(String uniqueId) {
        return (Library)new Select(new IProperty[0]).from(CloudLibrary.class).where().and((SQLCondition)CloudLibrary_Table.idString.eq((Object)uniqueId)).querySingle();
    }

    @Override
    public QueryResult<Library> fetchAllLibrary(String parentId, QueryArgs queryArgs) {
        QueryResult<Library> result;
        if (FetchPolicy.isCloudPartPolicy(queryArgs.fetchPolicy)) {
            result = this.fetchLibraryListFromCloud(queryArgs.libraryUniqueId, queryArgs);
        } else {
            result = this.fetchLibraryListFromLocal(queryArgs.libraryUniqueId);
            if (FetchPolicy.isMemDbCloudPolicy(queryArgs.fetchPolicy) && !QueryResult.isValidQueryResult(result)) {
                result = this.fetchLibraryListFromCloud(queryArgs.libraryUniqueId, queryArgs);
            }
        }
        return result;
    }

    @Override
    public List<Library> loadAllLibrary(String parentId, QueryArgs queryArgs) {
        QueryResult<Library> result = this.fetchAllLibrary(parentId, queryArgs);
        return result.list;
    }

    public QueryResult<Library> fetchLibraryListFromCloud(String parentId, QueryArgs queryArgs) {
        QueryResult<Library> result;
        block4: {
            result = new QueryResult<Library>();
            try {
                Response<QueryResult<CloudLibrary>> response = RetrofitUtils.executeCall(this.getContentService().loadLibraryList(parentId));
                if (response.isSuccessful()) {
                    result.list = new ArrayList();
                    for (CloudLibrary library : ((QueryResult)response.body()).list) {
                        result.list.add(library);
                    }
                    result.count = ((QueryResult)response.body()).count;
                    result.fetchSource = Metadata.FetchSource.CLOUD;
                }
            }
            catch (Exception e) {
                if (FetchPolicy.isCloudOnlyPolicy(queryArgs.fetchPolicy) || FetchPolicy.isMemDbCloudPolicy(queryArgs.fetchPolicy)) break block4;
                result = this.fetchLibraryListFromLocal(parentId);
            }
        }
        return result;
    }

    public QueryResult<Library> fetchLibraryListFromLocal(String parentId) {
        QueryResult<Library> result = new QueryResult<Library>();
        List cloudLibraryList = new Select(new IProperty[0]).from(CloudLibrary.class).where().and((SQLCondition)CloudLibrary_Table.parentUniqueId.eq((Object)parentId)).queryList();
        if (CollectionUtils.isNullOrEmpty((Collection)cloudLibraryList)) {
            return result;
        }
        result.list = new ArrayList();
        for (CloudLibrary library : cloudLibraryList) {
            result.list.add(library);
        }
        result.count = cloudLibraryList.size();
        result.fetchSource = Metadata.FetchSource.LOCAL;
        return result;
    }

    @Override
    public void addLibrary(Library library) {
        Library findLibrary = this.loadLibrary(library.getIdString());
        if (findLibrary != null) {
            library.setId(findLibrary.getId());
        }
        library.save();
    }

    @Override
    public void updateLibrary(Library library) {
    }

    @Override
    public void deleteLibrary(Library library) {
        library.delete();
    }

    @Override
    public void clearLibrary() {
        Delete.table(CloudLibrary.class, (SQLCondition[])new SQLCondition[0]);
    }

    @Override
    public void clearThumbnails() {
    }

    @Override
    public void saveThumbnailEntry(Context context, Thumbnail thumbnail) {
        Thumbnail getThumbnail = this.getThumbnailEntry(context, thumbnail.getIdString(), thumbnail.getThumbnailKind());
        if (getThumbnail != null) {
            thumbnail.setId(getThumbnail.getId());
        }
        thumbnail.save();
    }

    @Override
    public Thumbnail getThumbnailEntry(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        return (Thumbnail)new Select(new IProperty[0]).from(Thumbnail.class).where().and((SQLCondition)Thumbnail_Table.idString.eq((Object)associationId)).and((SQLCondition)Thumbnail_Table.thumbnailKind.eq((Object)kind)).querySingle();
    }

    @Override
    public void deleteThumbnailEntry(Thumbnail thumbnail) {
    }

    @Override
    public boolean saveThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap saveBitmap) {
        return false;
    }

    @Override
    public Bitmap getThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        return null;
    }

    @Override
    public boolean removeThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        return false;
    }

    @Override
    public void clearMetadataCollection() {
    }

    @Override
    public void addMetadataCollection(Context context, MetadataCollection collection) {
        MetadataCollection findCollection = this.loadMetadataCollection(context, collection.getLibraryUniqueId(), collection.getDocumentUniqueId());
        if (findCollection != null) {
            collection.setId(findCollection.getId());
        }
        collection.save();
    }

    @Override
    public void deleteMetadataCollection(Context context, String libraryUniqueId, String associationId) {
        new Delete().from(CloudMetadataCollection.class).where(new SQLCondition[]{CloudMetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)}).and((SQLCondition)CloudMetadataCollection_Table.documentUniqueId.eq((Object)associationId)).execute();
    }

    @Override
    public void deleteMetadataCollection(Context context, String libraryUniqueId) {
        new Delete().from(CloudMetadataCollection.class).where(new SQLCondition[]{CloudMetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)}).execute();
    }

    @Override
    public void deleteMetadataCollectionByDocId(Context context, String docId) {
        new Delete().from(CloudMetadataCollection.class).where(new SQLCondition[]{CloudMetadataCollection_Table.documentUniqueId.eq((Object)docId)}).execute();
    }

    @Override
    public void updateMetadataCollection(MetadataCollection collection) {
        collection.update();
    }

    @Override
    public MetadataCollection loadMetadataCollection(Context context, String libraryUniqueId, String associationId) {
        return (MetadataCollection)new Select(new IProperty[0]).from(CloudMetadataCollection.class).where(new SQLCondition[]{CloudMetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)}).and((SQLCondition)CloudMetadataCollection_Table.documentUniqueId.eq((Object)associationId)).querySingle();
    }

    @Override
    public List<MetadataCollection> loadMetadataCollection(Context context, String libraryUniqueId) {
        List list = new Select(new IProperty[0]).from(CloudMetadataCollection.class).where(new SQLCondition[]{CloudMetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)}).queryList();
        if (CollectionUtils.isNullOrEmpty((Collection)list)) {
            return new ArrayList<MetadataCollection>();
        }
        ArrayList<MetadataCollection> collectionList = new ArrayList<MetadataCollection>();
        for (CloudMetadataCollection collection : list) {
            collectionList.add(collection);
        }
        return collectionList;
    }

    @Override
    public MetadataCollection findMetadataCollection(Context context, String associationId) {
        return (MetadataCollection)new Select(new IProperty[0]).from(CloudMetadataCollection.class).where(new SQLCondition[]{CloudMetadataCollection_Table.documentUniqueId.eq((Object)associationId)}).querySingle();
    }

    private ContentService getContentService() {
        return ServiceFactory.getContentService(this.conf.getApiBase());
    }
}

