/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.content.Context;
import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.data.model.SecurePreferences;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class OnyxAccount
extends BaseData {
    private static final String CLOUD_TYPE = "onyxCloud";
    private static final String ACCOUNT_INFO_TAG = "accountInfo";
    private static final String JSON_TAG = "json";
    private static AccountInfo accountInfo = new AccountInfo();
    public String nickName;
    public String firstName;
    public String lastName;
    public String fullName;
    public String password;
    public String email;
    public String mobile;
    public String sessionToken;
    public String captchaId;
    public String captchaValue;
    public boolean isInstallationId = false;
    public String deviceClient = "boox";
    public String type;
    public String avatarUrl;
    public int status;

    public OnyxAccount() {
    }

    public OnyxAccount(String fullName, String password, String email) {
        this.fullName = fullName;
        this.password = password;
        this.email = email;
    }

    public static OnyxAccount getCurrentAccount() {
        return accountInfo.getCurrentAccount();
    }

    public static OnyxAccount defaultAccount() {
        OnyxAccount account = new OnyxAccount("john2", "123456", "john2@onyx-international.com");
        return account;
    }

    public static void generateDefaultAccount(Context context) {
        OnyxAccount.clear(context);
        OnyxAccount.saveAccount(context, OnyxAccount.defaultAccount());
    }

    public static AccountInfo getAccountInfo() {
        return accountInfo;
    }

    public static void saveAccount(Context context, OnyxAccount onyxAccount) {
        accountInfo.addAccount(onyxAccount);
        SecurePreferences preferences = new SecurePreferences(context, CLOUD_TYPE, ACCOUNT_INFO_TAG, true);
        preferences.put(JSON_TAG, JSON.toJSONString((Object)accountInfo));
    }

    public static OnyxAccount loadAccount(Context context) {
        SecurePreferences preferences = new SecurePreferences(context, CLOUD_TYPE, ACCOUNT_INFO_TAG, true);
        String string2 = preferences.getString(JSON_TAG);
        if (StringUtils.isNullOrEmpty((String)string2)) {
            accountInfo = new AccountInfo();
            return null;
        }
        accountInfo = (AccountInfo)JSON.parseObject((String)string2, AccountInfo.class);
        return accountInfo.getCurrentAccount();
    }

    public static String loadAccountSessionToken(Context context) {
        if (accountInfo.getCurrentAccount() != null) {
            return OnyxAccount.accountInfo.getCurrentAccount().sessionToken;
        }
        OnyxAccount account = OnyxAccount.loadAccount(context);
        return account == null ? null : account.sessionToken;
    }

    public static void clear(Context context) {
        SecurePreferences preferences = new SecurePreferences(context, CLOUD_TYPE, ACCOUNT_INFO_TAG, true);
        preferences.clear();
        accountInfo.clear();
    }

    public static class AccountInfo {
        public LinkedHashMap<String, OnyxAccount> accountMap = new LinkedHashMap(16, 0.75f, true);
        public OnyxAccount currentAccount;

        public OnyxAccount getCurrentAccount() {
            if (this.currentAccount == null && this.accountMap.size() > 0) {
                Iterator<Map.Entry<String, OnyxAccount>> iterator = this.accountMap.entrySet().iterator();
                for (int i = 0; i < this.accountMap.size() - 1; ++i) {
                    iterator.next();
                }
                this.currentAccount = iterator.next().getValue();
            }
            return this.currentAccount;
        }

        public void addAccount(OnyxAccount account) {
            this.accountMap.put(account.sessionToken, account);
            this.currentAccount = account;
        }

        public void clear() {
            this.accountMap.clear();
            this.currentAccount = null;
        }
    }
}

