/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.content.Context;
import android.os.Build;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.PackageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ApplicationUpdate
extends BaseData {
    public String channel;
    public String packageName;
    public String model;
    public String[] downloadUrlList;
    public Map<String, List<String>> changeLogs;
    public String type;
    public String versionName;
    public int versionCode;
    public int size;
    public String macAddress;
    public String platform;

    public String getFirstDownloadUrl() {
        if (this.downloadUrlList == null || this.downloadUrlList.length <= 0) {
            return null;
        }
        return this.downloadUrlList[0];
    }

    public List<String> getChangeLogList() {
        if (CollectionUtils.isNullOrEmpty(this.changeLogs)) {
            return new ArrayList<String>();
        }
        List<String> changeLogList = this.changeLogs.get(Locale.getDefault().toString());
        if (CollectionUtils.isNullOrEmpty(changeLogList)) {
            String enUsKey = Locale.US.toString();
            changeLogList = this.changeLogs.get(enUsKey);
        }
        if (changeLogList == null) {
            changeLogList = new ArrayList<String>();
        }
        return changeLogList;
    }

    public static ApplicationUpdate create(Context context) {
        ApplicationUpdate appUpdate = new ApplicationUpdate();
        appUpdate.versionCode = PackageUtils.getAppVersionCode((Context)context);
        appUpdate.versionName = PackageUtils.getAppVersionName((Context)context);
        appUpdate.packageName = context.getPackageName();
        appUpdate.platform = PackageUtils.getAppPlatform((Context)context);
        appUpdate.channel = PackageUtils.getAppChannel((Context)context);
        appUpdate.type = PackageUtils.getAppType((Context)context);
        appUpdate.model = Build.MODEL;
        return appUpdate;
    }
}

