/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.manager;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PushActionManager {
    public static List<String> PUSH_DATA = new ArrayList<String>();
    public static List<String> PUSH_CHANNEL = new ArrayList<String>();
    private DataManager dataManager = new DataManager();
    private CloudManager cloudManager = new CloudManager();
    private Map<String, Class<? extends PushAction>> pushActionMap = new HashMap<String, Class<? extends PushAction>>();

    public void addAction(String action, Class<? extends PushAction> clazz) {
        if (StringUtils.isNullOrEmpty((String)action) || clazz == null) {
            return;
        }
        this.pushActionMap.put(action, clazz);
    }

    public void processPushAction(Context context, Intent intent) {
        String action = intent.getAction();
        if (StringUtils.isNotBlank((String)action) && this.pushActionMap.containsKey(action)) {
            PushAction pushAction = this.getPushAction(this.pushActionMap.get(action));
            if (pushAction == null) {
                return;
            }
            pushAction.execute(PushActionContext.create(context, this.getCloudManager(), this.getDataManager(), intent));
        }
    }

    private PushAction getPushAction(Class<? extends PushAction> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPushData(Intent intent) {
        for (int i = 0; i < PUSH_DATA.size(); ++i) {
            String data = intent.getExtras().getString(PUSH_DATA.get(i));
            if (!StringUtils.isNotBlank((String)data)) continue;
            return data;
        }
        return null;
    }

    public CloudManager getCloudManager() {
        return this.cloudManager;
    }

    public void setCloudManager(CloudManager cloudManager) {
        this.cloudManager = cloudManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public void setDataManager(DataManager dataManager) {
        this.dataManager = dataManager;
    }

    public static class PushActionContext {
        public Context context;
        public CloudManager cloudManager;
        public DataManager dataManager;
        public Intent intent;

        private PushActionContext() {
        }

        public static PushActionContext create(@NonNull Context context, @NonNull CloudManager cloudManager, @NonNull DataManager dataManager, @NonNull Intent intent) {
            PushActionContext actionContext = new PushActionContext();
            actionContext.context = context;
            actionContext.cloudManager = cloudManager;
            actionContext.dataManager = dataManager;
            actionContext.intent = intent;
            return actionContext;
        }
    }

    public static abstract class PushAction {
        public abstract void execute(PushActionContext var1);
    }
}

