/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.manager;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.common.request.BaseRequest;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.OnyxDownloadManager;
import com.onyx.android.sdk.data.model.ApplicationUpdate;
import com.onyx.android.sdk.data.request.cloud.ApplicationUpdateRequest;
import com.onyx.android.sdk.data.utils.NotificationItem;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.PackageUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AppUpdateManager {
    public static final String PHONE_APPLICATION_MODEL = "mobile";

    public static ApplicationUpdate getApplicationUpdate(Context context) {
        ApplicationUpdate appUpdate = ApplicationUpdate.create(context);
        appUpdate.model = PHONE_APPLICATION_MODEL;
        return appUpdate;
    }

    public static String getApkFilePath(Context context, ApplicationUpdate update) {
        String packageName = update.packageName.replaceAll("\\.", "_");
        return new File(context.getExternalCacheDir(), packageName + "_" + update.versionCode + ".apk").getAbsolutePath();
    }

    private static String getDownloadUrl(ApplicationUpdate update) {
        return update.getFirstDownloadUrl();
    }

    public static void checkUpdate(Context context, CloudManager cloudManager, AppUpdateConfig config) {
        AppUpdateManager.checkUpdate(context, cloudManager, config, null);
    }

    public static void checkUpdate(Context context, CloudManager cloudManager, AppUpdateConfig config, BaseCallback customCallBack) {
        ArrayList<ApplicationUpdate> queryList = new ArrayList<ApplicationUpdate>();
        queryList.add(AppUpdateManager.getApplicationUpdate(context));
        AppUpdateManager.checkUpdate(context, cloudManager, config, queryList, customCallBack);
    }

    public static void checkUpdate(final Context context, CloudManager cloudManager, final AppUpdateConfig config, List<ApplicationUpdate> queryList, final BaseCallback customCallBack) {
        final ApplicationUpdateRequest singleUpdateRequest = new ApplicationUpdateRequest(queryList);
        cloudManager.submitRequest(context, singleUpdateRequest, new BaseCallback(){

            public void done(BaseRequest request, Throwable e) {
                BaseCallback.invoke((BaseCallback)customCallBack, (BaseRequest)request, (Throwable)e);
                if (e == null && config.autoDownload) {
                    AppUpdateManager.checkUpdatedFileDownload(context, config, singleUpdateRequest.getUpdateList(), null);
                }
            }
        });
    }

    private static PendingIntent getInstallPendingIntent(Context context, File file) {
        return PendingIntent.getActivity((Context)context, (int)0, (Intent)PackageUtils.getInstallIntent((File)file), (int)0x8000000);
    }

    private static NotificationItem.NotificationBean buildDownloadNotificationBean(Context context, AppUpdateConfig config, ApplicationUpdate update, File file) {
        NotificationItem.NotificationBean bean = new NotificationItem.NotificationBean();
        bean.title = PackageUtils.getAppDisplayName((Context)context, (String)context.getPackageName());
        bean.desc = update.versionName;
        bean.icon = config.notificationSmallIcon;
        bean.largeIcon = config.notificationLargeIcon;
        bean.pendingIntent = AppUpdateManager.getInstallPendingIntent(context, file);
        return bean;
    }

    public static boolean checkUpdatedFileDownload(Context context, AppUpdateConfig config, ApplicationUpdate update, BaseCallback downloadCallback) {
        if (update == null) {
            return false;
        }
        String filePath = AppUpdateManager.getApkFilePath(context, update);
        File file = new File(filePath);
        String url = AppUpdateManager.getDownloadUrl(update);
        if (StringUtils.isNullOrEmpty((String)url)) {
            return false;
        }
        BaseDownloadTask task = OnyxDownloadManager.getInstance().downloadWithNotify(url, filePath, filePath, AppUpdateManager.buildDownloadNotificationBean(context, config, update, file), downloadCallback);
        task.setForceReDownload(true);
        return OnyxDownloadManager.getInstance().startDownload(task) != 0;
    }

    public static boolean checkUpdatedFileDownload(Context context, AppUpdateConfig config, List<ApplicationUpdate> updatingList, BaseCallback downloadCallback) {
        if (CollectionUtils.isNullOrEmpty(updatingList)) {
            return false;
        }
        boolean result = true;
        for (ApplicationUpdate appUpdate : updatingList) {
            result &= AppUpdateManager.checkUpdatedFileDownload(context, config, appUpdate, downloadCallback);
        }
        return result;
    }

    public static class AppUpdateConfig {
        public int notificationSmallIcon;
        public Bitmap notificationLargeIcon;
        public boolean autoDownload;

        public static AppUpdateConfig create(int smallIcon, boolean autoDownload) {
            AppUpdateConfig config = new AppUpdateConfig();
            config.notificationSmallIcon = smallIcon;
            config.autoDownload = autoDownload;
            return config;
        }
    }
}

