/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.compatability;

import android.content.Context;
import android.util.Log;
import com.onyx.android.sdk.data.compatability.OnyxBookProgress;
import com.onyx.android.sdk.data.compatability.OnyxCmsCenter;
import com.onyx.android.sdk.data.compatability.OnyxHistoryEntry;
import java.util.Date;
import java.util.List;

public class OnyxHistoryEntryHelper {
    private static final String Tag = "OnyxHistoryEntryHelper";
    private static final boolean VERBOSE_LOG = false;
    private static OnyxHistoryEntry sHistoryEntry = null;

    public static void recordStartReading(Context context, String md5, OnyxBookProgress bookProgress) {
        sHistoryEntry = new OnyxHistoryEntry();
        sHistoryEntry.setStartTime(new Date());
        sHistoryEntry.setEndTime(new Date());
        sHistoryEntry.setProgress(bookProgress);
        sHistoryEntry.setMD5(md5);
        OnyxCmsCenter.insertHistory(context, sHistoryEntry);
    }

    public static void recordFinishReading(Context context, OnyxBookProgress bookProgress) {
        if (sHistoryEntry == null) {
            return;
        }
        Date old_end_time = sHistoryEntry.getEndTime();
        Date new_end_time = new Date();
        int durationTime = 10;
        if (new_end_time.getTime() - old_end_time.getTime() >= (long)(durationTime * 60 * 1000)) {
            Log.d((String)Tag, (String)("Read idle for " + durationTime + " minutes timeout"));
            OnyxHistoryEntryHelper.recordStartReading(context, sHistoryEntry.getMD5(), bookProgress);
            return;
        }
        sHistoryEntry.setEndTime(new_end_time);
        sHistoryEntry.setProgress(bookProgress);
        OnyxCmsCenter.updateHistory(context, sHistoryEntry);
    }

    public static List<OnyxHistoryEntry> getHistorysByMD5(Context context, String md5) {
        return OnyxCmsCenter.getHistorysByMD5(context, md5);
    }

    public static long getTotalReadingTimeInSeconds(Context context, String md5) {
        long total = 0L;
        List<OnyxHistoryEntry> entryList = OnyxHistoryEntryHelper.getHistorysByMD5(context, md5);
        if (entryList != null) {
            for (OnyxHistoryEntry entry : entryList) {
                total += (entry.getEndTime().getTime() - entry.getStartTime().getTime()) / 1000L;
            }
        }
        return total;
    }

    public static boolean deleteHistoryByMD5(Context context, String md5) {
        return OnyxCmsCenter.deleteHistoryByMD5Only(context, md5);
    }

    public static boolean deleteAllHistory(Context context) {
        return OnyxCmsCenter.deleteAllHistory(context);
    }
}

