/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.compatability;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.BaseColumns;
import com.onyx.android.sdk.data.compatability.CursorUtil;
import com.onyx.android.sdk.data.compatability.OnyxBookProgress;
import com.onyx.android.sdk.data.compatability.SerializationUtil;
import java.io.Serializable;
import java.util.Date;

public class OnyxHistoryEntry
implements Serializable,
Parcelable {
    private static final String TAG = "OnyxHistoryEntry";
    public static final String DB_TABLE_NAME = "library_history";
    private static final long serialVersionUID = 1L;
    public static final Uri CONTENT_URI = Uri.parse((String)"content://com.onyx.android.sdk.OnyxCmsProvider/library_history");
    public static int HISTORY_THRESHOLD = 300;
    private long mId = -1L;
    private String mMD5 = null;
    private Date mStartTime = null;
    private Date mEndTime = null;
    private OnyxBookProgress mProgress = null;
    private String mApplication = null;
    private String mExtraAttributes = null;
    public static final Parcelable.Creator<OnyxHistoryEntry> CREATOR = new Parcelable.Creator<OnyxHistoryEntry>(){

        public OnyxHistoryEntry createFromParcel(Parcel source) {
            return new OnyxHistoryEntry(source);
        }

        public OnyxHistoryEntry[] newArray(int size) {
            return new OnyxHistoryEntry[size];
        }
    };

    public OnyxHistoryEntry() {
    }

    public OnyxHistoryEntry(Parcel source) {
        this.readFromParcel(source);
    }

    public long getId() {
        return this.mId;
    }

    public void setId(long id) {
        this.mId = id;
    }

    public String getMD5() {
        return this.mMD5;
    }

    public void setMD5(String md5) {
        this.mMD5 = md5;
    }

    public Date getStartTime() {
        return this.mStartTime;
    }

    public void setStartTime(Date time) {
        this.mStartTime = time;
    }

    public Date getEndTime() {
        return this.mEndTime;
    }

    public void setEndTime(Date time) {
        this.mEndTime = time;
    }

    public OnyxBookProgress getProgress() {
        return this.mProgress;
    }

    public void setProgress(OnyxBookProgress progress) {
        this.mProgress = progress;
    }

    public String getApplication() {
        return this.mApplication;
    }

    public void setApplication(String application) {
        this.mApplication = application;
    }

    public String getExtraAttributes() {
        return this.mExtraAttributes;
    }

    public void setExtraAttributes(String extraAttributes) {
        this.mExtraAttributes = extraAttributes;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mId);
        dest.writeString(this.mMD5);
        dest.writeString(SerializationUtil.dateToString(this.mStartTime));
        dest.writeString(SerializationUtil.dateToString(this.mEndTime));
        dest.writeString(this.mApplication);
    }

    public void readFromParcel(Parcel source) {
        this.mId = source.readLong();
        this.mMD5 = source.readString();
        this.mStartTime = SerializationUtil.dateFromString(source.readString());
        this.mEndTime = SerializationUtil.dateFromString(source.readString());
        this.mApplication = source.readString();
    }

    public static class Columns
    implements BaseColumns {
        public static String MD5 = "MD5";
        public static final String START_TIME = "StartTime";
        public static final String END_TIME = "EndTime";
        public static final String PROGRESS = "Progress";
        public static final String APPLICATION = "Application";
        public static String EXTRA_ATTRIBUTES = "ExtraAttributes";
        private static boolean sColumnIndexesInitialized = false;
        private static int sColumnID = -1;
        private static int sColumnMD5 = -1;
        private static int sColumnStartTime = -1;
        private static int sColumnEndTime = -1;
        private static int sColumnProgress = -1;
        private static int sColumnApplication = -1;
        private static int sColumnExtraAttributes = -1;

        public static ContentValues createColumnData(OnyxHistoryEntry entry) {
            ContentValues values = new ContentValues();
            values.put(MD5, entry.getMD5());
            values.put(START_TIME, Long.valueOf(entry.getStartTime() == null ? 0L : entry.getStartTime().getTime()));
            values.put(END_TIME, Long.valueOf(entry.getEndTime() == null ? 0L : entry.getEndTime().getTime()));
            values.put(PROGRESS, entry.getProgress() == null ? "" : entry.getProgress().toString());
            values.put(APPLICATION, entry.getApplication());
            return values;
        }

        public static OnyxHistoryEntry readColumnsData(Cursor c) {
            if (!sColumnIndexesInitialized) {
                sColumnID = c.getColumnIndex("_id");
                sColumnMD5 = c.getColumnIndex(MD5);
                sColumnStartTime = c.getColumnIndex(START_TIME);
                sColumnEndTime = c.getColumnIndex(END_TIME);
                sColumnProgress = c.getColumnIndex(PROGRESS);
                sColumnApplication = c.getColumnIndex(APPLICATION);
                sColumnExtraAttributes = c.getColumnIndex(EXTRA_ATTRIBUTES);
                sColumnIndexesInitialized = true;
            }
            long id = c.getLong(sColumnID);
            String md5 = CursorUtil.getString(c, sColumnMD5);
            Long start_time = CursorUtil.getLong(c, sColumnStartTime);
            Long end_time = CursorUtil.getLong(c, sColumnEndTime);
            OnyxBookProgress progress = OnyxBookProgress.fromString(CursorUtil.getString(c, sColumnProgress));
            String application = CursorUtil.getString(c, sColumnApplication);
            String extra_attributes = CursorUtil.getString(c, sColumnExtraAttributes);
            OnyxHistoryEntry entry = new OnyxHistoryEntry();
            entry.setId(id);
            entry.setMD5(md5);
            entry.setStartTime(new Date(start_time == null ? 0L : start_time));
            entry.setEndTime(new Date(end_time == null ? 0L : end_time));
            entry.setProgress(progress);
            entry.setApplication(application);
            entry.setExtraAttributes(extra_attributes);
            return entry;
        }
    }
}

