/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.compatability;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import com.onyx.android.sdk.data.RefValue;
import com.onyx.android.sdk.data.compatability.OnyxHistoryEntry;
import com.onyx.android.sdk.data.compatability.OnyxMetadata;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class OnyxCmsCenter {
    private static final String TAG = "OnyxCMSCenter";
    public static final String PROVIDER_AUTHORITY = "com.onyx.android.sdk.OnyxCmsProvider";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getMetadata(Context context, OnyxMetadata data) {
        try (Cursor c = null;){
            c = context.getContentResolver().query(OnyxMetadata.CONTENT_URI, null, OnyxMetadata.Columns.MD5 + "= ?", new String[]{data.getMD5()}, null);
            if (c == null) {
                Log.w((String)TAG, (String)"getMetadata, query database failed");
                boolean bl = false;
                return bl;
            }
            if (c.moveToFirst()) {
                OnyxMetadata.Columns.readColumnData(c, data);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static boolean insertMetadata(Context context, OnyxMetadata data) {
        OnyxCmsCenter.deleteMetadata(context, data);
        Uri result = context.getContentResolver().insert(OnyxMetadata.CONTENT_URI, OnyxMetadata.Columns.createColumnData(data));
        if (result == null) {
            return false;
        }
        String id = result.getLastPathSegment();
        if (id == null) {
            return false;
        }
        data.setId(Long.parseLong(id));
        return true;
    }

    public static boolean deleteMetadata(Context context, OnyxMetadata data) {
        if (StringUtils.isNotBlank((String)data.getMD5()) && context.getContentResolver().delete(OnyxMetadata.CONTENT_URI, OnyxMetadata.Columns.MD5 + "=?", new String[]{data.getMD5()}) > 0) {
            return true;
        }
        return context.getContentResolver().delete(OnyxMetadata.CONTENT_URI, OnyxMetadata.Columns.NATIVE_ABSOLUTE_PATH + "=?", new String[]{data.getNativeAbsolutePath()}) > 0;
    }

    public static boolean updateMetadata(Context context, OnyxMetadata data) {
        Uri row = Uri.withAppendedPath((Uri)OnyxMetadata.CONTENT_URI, (String)String.valueOf(data.getId()));
        int count = context.getContentResolver().update(row, OnyxMetadata.Columns.createColumnData(data), null, null);
        if (count <= 0) {
            return false;
        }
        assert (count == 1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasThumbnail(Context context, OnyxMetadata metadata) {
        if (metadata == null) {
            assert (false);
            return false;
        }
        try (Cursor c = null;){
            c = OnyxCmsCenter.getThumbnailCursor(context, metadata.getMD5(), OnyxThumbnail.ThumbnailKind.Original);
            if (c == null) {
                Log.w((String)TAG, (String)"query original thumbnail failed");
                boolean bl = false;
                return bl;
            }
            boolean bl = c.moveToFirst();
            return bl;
        }
    }

    public static boolean getThumbnail(Context context, OnyxMetadata metadata, OnyxThumbnail.ThumbnailKind thumbnailKind, RefValue<Bitmap> result) {
        if (metadata == null) {
            assert (false);
            return false;
        }
        return OnyxCmsCenter.getThumbnailByMD5(context, metadata.getMD5(), thumbnailKind, result);
    }

    public static boolean getThumbnail(Context context, OnyxMetadata metadata, RefValue<Bitmap> result) {
        return OnyxCmsCenter.getThumbnail(context, metadata, OnyxThumbnail.ThumbnailKind.Original, result);
    }

    /*
     * Exception decompiling
     */
    public static boolean getThumbnailByMD5(Context context, String md5, OnyxThumbnail.ThumbnailKind thumbnailKind, RefValue<Bitmap> result) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean insertThumbnail(Context context, OnyxMetadata data, Bitmap thumbnail) {
        if (data == null) {
            assert (false);
            return false;
        }
        if (!OnyxCmsCenter.insertThumbnailHelper(context, thumbnail, data.getMD5(), OnyxThumbnail.ThumbnailKind.Original)) {
            return false;
        }
        OnyxCmsCenter.insertThumbnailHelper(context, thumbnail, data.getMD5(), OnyxThumbnail.ThumbnailKind.Large);
        OnyxCmsCenter.insertThumbnailHelper(context, thumbnail, data.getMD5(), OnyxThumbnail.ThumbnailKind.Middle);
        OnyxCmsCenter.insertThumbnailHelper(context, thumbnail, data.getMD5(), OnyxThumbnail.ThumbnailKind.Small);
        return true;
    }

    private static Cursor getThumbnailCursor(Context context, String md5, OnyxThumbnail.ThumbnailKind kind) {
        return context.getContentResolver().query(OnyxThumbnail.CONTENT_URI, null, OnyxThumbnail.Columns.SOURCE_MD5 + "='" + md5 + "' AND " + OnyxThumbnail.Columns.THUMBNAIL_KIND + "='" + kind.toString() + "'", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean insertThumbnailHelper(Context context, Bitmap bmp, String md5, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        Bitmap thumbnail = bmp;
        OutputStream os = null;
        try {
            switch (thumbnailKind) {
                case Original: {
                    break;
                }
                case Large: {
                    thumbnail = OnyxThumbnail.createLargeThumbnail(bmp);
                    break;
                }
                case Middle: {
                    thumbnail = OnyxThumbnail.createMiddleThumbnail(bmp);
                    break;
                }
                case Small: {
                    thumbnail = OnyxThumbnail.createSmallThumbnail(bmp);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            Uri result = context.getContentResolver().insert(OnyxThumbnail.CONTENT_URI, OnyxThumbnail.Columns.createColumnData(md5, thumbnailKind));
            if (result == null) {
                Log.w((String)TAG, (String)"insertThumbnail db insert failed");
                boolean bl = false;
                return bl;
            }
            os = context.getContentResolver().openOutputStream(result);
            if (os == null) {
                Log.w((String)TAG, (String)"openOutputStream failed");
                boolean bl = false;
                return bl;
            }
            thumbnail.compress(Bitmap.CompressFormat.JPEG, 85, os);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            Log.w((String)TAG, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (thumbnail != null && thumbnail != bmp) {
                thumbnail.recycle();
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OnyxMetadata getMetadataByCloudReference(Context context, String cloudReference) {
        OnyxMetadata data;
        Cursor c;
        block4: {
            OnyxMetadata onyxMetadata;
            c = null;
            data = null;
            try {
                c = context.getContentResolver().query(OnyxMetadata.CONTENT_URI, null, OnyxMetadata.Columns.CLOUD_REFERENCE + "= ?", new String[]{cloudReference}, null);
                if (c != null) break block4;
                onyxMetadata = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(c);
                throw throwable;
            }
            FileUtils.closeQuietly((Cursor)c);
            return onyxMetadata;
        }
        if (c.moveToFirst()) {
            data = OnyxMetadata.Columns.readColumnData(c);
        }
        OnyxMetadata onyxMetadata = data;
        FileUtils.closeQuietly((Cursor)c);
        return onyxMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OnyxMetadata getMetadataByMD5(Context context, String md5) {
        OnyxMetadata data = null;
        try (Cursor c = null;){
            c = context.getContentResolver().query(OnyxMetadata.CONTENT_URI, null, OnyxMetadata.Columns.MD5 + "= ?", new String[]{md5}, null);
            if (c == null) {
                Log.w((String)TAG, (String)"getMetadatas, query database failed");
                OnyxMetadata onyxMetadata = null;
                return onyxMetadata;
            }
            if (c.moveToFirst()) {
                data = OnyxMetadata.Columns.readColumnData(c);
            }
            OnyxMetadata onyxMetadata = data;
            return onyxMetadata;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OnyxHistoryEntry> getHistoryByApplication(Context context, String application) {
        ArrayList<OnyxHistoryEntry> historyEntries = new ArrayList<OnyxHistoryEntry>();
        try (Cursor c = null;){
            c = context.getContentResolver().query(OnyxHistoryEntry.CONTENT_URI, null, "Application= ?", new String[]{application}, null);
            if (c == null) {
                Log.w((String)TAG, (String)"getHistoryByApplication, query database failed");
                List<OnyxHistoryEntry> list = null;
                return list;
            }
            c.moveToFirst();
            while (!c.isAfterLast()) {
                OnyxHistoryEntry history_entry = OnyxHistoryEntry.Columns.readColumnsData(c);
                historyEntries.add(history_entry);
                c.moveToNext();
            }
            ArrayList<OnyxHistoryEntry> arrayList = historyEntries;
            return arrayList;
        }
    }

    public static boolean insertHistory(Context context, OnyxHistoryEntry historyEntry) {
        return OnyxCmsCenter.insertHistory(context, context.getPackageName(), historyEntry);
    }

    public static boolean insertHistory(Context context, String application, OnyxHistoryEntry historyEntry) {
        historyEntry.setApplication(application);
        Uri result = context.getContentResolver().insert(OnyxHistoryEntry.CONTENT_URI, OnyxHistoryEntry.Columns.createColumnData(historyEntry));
        if (result == null) {
            return false;
        }
        String id = result.getLastPathSegment();
        if (id == null) {
            return false;
        }
        historyEntry.setId(Long.parseLong(id));
        return true;
    }

    public static boolean updateHistory(Context context, OnyxHistoryEntry onyxHistoryEntry) {
        return OnyxCmsCenter.updateHistory(context, context.getPackageName(), onyxHistoryEntry);
    }

    public static boolean updateHistory(Context context, String application, OnyxHistoryEntry onyxHistoryEntry) {
        onyxHistoryEntry.setApplication(application);
        Uri row = Uri.withAppendedPath((Uri)OnyxHistoryEntry.CONTENT_URI, (String)String.valueOf(onyxHistoryEntry.getId()));
        int count = context.getContentResolver().update(row, OnyxHistoryEntry.Columns.createColumnData(onyxHistoryEntry), null, null);
        if (count <= 0) {
            return false;
        }
        assert (count == 1);
        return true;
    }

    public static List<OnyxHistoryEntry> getHistorysByMD5(Context context, String md5) {
        return OnyxCmsCenter.getHistorysByMD5(context, context.getPackageName(), md5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OnyxHistoryEntry> getHistorysByMD5(Context context, String application, String md5) {
        ArrayList<OnyxHistoryEntry> historyEntries = new ArrayList<OnyxHistoryEntry>();
        try (Cursor c = null;){
            c = context.getContentResolver().query(OnyxHistoryEntry.CONTENT_URI, null, OnyxHistoryEntry.Columns.MD5 + "= ?", new String[]{md5}, null);
            if (c == null) {
                Log.w((String)TAG, (String)"getHistorysByMD5, query database failed");
                List<OnyxHistoryEntry> list = null;
                return list;
            }
            c.moveToFirst();
            while (!c.isAfterLast()) {
                OnyxHistoryEntry history_entry = OnyxHistoryEntry.Columns.readColumnsData(c);
                historyEntries.add(history_entry);
                c.moveToNext();
            }
            ArrayList<OnyxHistoryEntry> arrayList = historyEntries;
            return arrayList;
        }
    }

    public static boolean deleteHistoryByMD5(Context context, String md5) {
        return OnyxCmsCenter.deleteHistoryByMD5(context, context.getPackageName(), md5);
    }

    public static boolean deleteHistoryByMD5Only(Context context, String md5) {
        int result_code = context.getContentResolver().delete(OnyxHistoryEntry.CONTENT_URI, OnyxHistoryEntry.Columns.MD5 + " = ?", new String[]{md5});
        return result_code > 0;
    }

    public static boolean deleteHistoryByMD5(Context context, String application, String md5) {
        int result_code = context.getContentResolver().delete(OnyxHistoryEntry.CONTENT_URI, "Application = ? AND " + OnyxHistoryEntry.Columns.MD5 + " = ?", new String[]{application, md5});
        return result_code > 0;
    }

    public static boolean deleteAllHistory(Context context) {
        int result_code = context.getContentResolver().delete(OnyxHistoryEntry.CONTENT_URI, null, null);
        ContentValues cv = new ContentValues();
        cv.putNull(OnyxMetadata.Columns.LAST_ACCESS);
        context.getContentResolver().update(OnyxMetadata.CONTENT_URI, cv, null, null);
        return result_code > 0;
    }
}

