/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.common;

import com.onyx.android.sdk.data.utils.ResultCode;

public class ContentException
extends Exception {
    private int code;
    public static final int URL_INVALID_EXCEPTION = 1;
    public static final int FILE_PATH_EXCEPTION = 2;
    public static final int NETWORK_EXCEPTION = 3;
    public static final int TOKEN_EXCEPTION = 4;
    public static final int UNKNOWN_EXCEPTION = 65535;
    public static final int CLOUD_NO_FOUND = 404;
    public static final String URL_INVALID_EXCEPTION_MESSAGE = "Url is invalid.";
    public static final String FILE_PATH_EXCEPTION_MESSAGE = "File path is invalid.";
    public static final String NETWORK_EXCEPTION_MESSAGE = "Network is exception.";
    public static final String UNKNOWN_EXCEPTION_MESSAGE = "Unknown exception.";
    public static final String TOKEN_EXCEPTION_MESSAGE = "Token exception.";

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public ContentException(int theCode, String theMessage) {
        super(theMessage);
        this.code = theCode;
    }

    public ContentException(String message, Throwable cause) {
        super(message, cause);
    }

    public ContentException(Throwable cause) {
        super(cause);
    }

    public static ContentException createException(Exception e) {
        return ContentException.exceptionFromCode(65535, e.toString());
    }

    public static ContentException exceptionFromCode(int code, String errorMessage) {
        return new ContentException(code, errorMessage);
    }

    public static ContentException exceptionFromResultCode(ResultCode resultCode) {
        if (resultCode == null) {
            return ContentException.UnKnowException();
        }
        String exceptionMessage = resultCode.message;
        int code = resultCode.code;
        if (exceptionMessage == null) {
            exceptionMessage = NETWORK_EXCEPTION_MESSAGE;
        }
        return ContentException.exceptionFromCode(code, exceptionMessage);
    }

    public static ContentException UrlInvalidException() {
        return ContentException.exceptionFromCode(1, URL_INVALID_EXCEPTION_MESSAGE);
    }

    public static ContentException FilePathInvalidException() {
        return ContentException.exceptionFromCode(2, FILE_PATH_EXCEPTION_MESSAGE);
    }

    public static ContentException UnKnowException() {
        return ContentException.exceptionFromCode(65535, UNKNOWN_EXCEPTION_MESSAGE);
    }

    public static ContentException TokenException() {
        return ContentException.exceptionFromCode(4, TOKEN_EXCEPTION_MESSAGE);
    }

    public static boolean isNetworkException(Throwable throwable) {
        return throwable instanceof NetworkException;
    }

    public static boolean isCloudException(Throwable throwable) {
        return throwable instanceof CloudException;
    }

    public boolean isCloudNotFound() {
        return this.getCode() == 404;
    }

    public static class CloudException
    extends ContentException {
        public CloudException(ResultCode resultCode) {
            super(CloudException.exceptionFromResultCode(resultCode));
            this.setCode(resultCode == null ? 65535 : resultCode.code);
        }
    }

    public static class NetworkException
    extends ContentException {
        public NetworkException(Exception e) {
            super(e);
        }
    }
}

