/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.action.push;

import android.util.Log;
import com.alibaba.fastjson.parser.Feature;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.common.request.BaseRequest;
import com.onyx.android.sdk.data.OnyxDownloadManager;
import com.onyx.android.sdk.data.manager.PushActionManager;
import com.onyx.android.sdk.data.manager.ScreenSaverManager;
import com.onyx.android.sdk.data.model.common.ScreenSaverConfig;
import com.onyx.android.sdk.data.utils.JSONObjectParseUtils;
import com.onyx.android.sdk.utils.StringUtils;

public class PushScreenSaverAction
extends PushActionManager.PushAction {
    private static final String TAG = PushScreenSaverAction.class.getSimpleName();

    @Override
    public void execute(PushActionManager.PushActionContext actionContext) {
        String data = PushActionManager.getPushData(actionContext.intent);
        if (StringUtils.isNullOrEmpty((String)data)) {
            return;
        }
        PushScreenSaverModel model = JSONObjectParseUtils.parseObject(data, PushScreenSaverModel.class, new Feature[0]);
        if (model == null) {
            Log.w((String)TAG, (String)"NULL PushScreenSaverModel detected");
            return;
        }
        this.processPushModel(actionContext, model);
    }

    private void processPushModel(final PushActionManager.PushActionContext actionContext, final PushScreenSaverModel model) {
        final ScreenSaverConfig config = ScreenSaverManager.getScreenSaverConfig().copy();
        String filePath = ScreenSaverManager.getSourcePicPath(config, model.imageFileName);
        config.convertToGrayScale = model.convertToGrayScale;
        config.sourcePicPathString = filePath;
        BaseDownloadTask task = OnyxDownloadManager.getInstance().download(actionContext.context, model.imageUrl, filePath, model.imageUrl, new BaseCallback(){

            public void done(BaseRequest request, Throwable e) {
                if (e != null) {
                    return;
                }
                PushScreenSaverAction.this.setScreenSaver(actionContext, config, model);
            }
        });
        OnyxDownloadManager.getInstance().startDownload(task);
    }

    private void setScreenSaver(PushActionManager.PushActionContext actionContext, ScreenSaverConfig config, PushScreenSaverModel model) {
        if (model.isAllSet()) {
            ScreenSaverManager.setAllScreenSaver(actionContext.context, actionContext.dataManager, config, null);
        } else {
            config.targetPicPathString = config.createTargetPicPath(config.screenSaverInitialNumber + model.index);
            ScreenSaverManager.setOneScreenSaver(actionContext.context, actionContext.dataManager, config, null);
        }
    }

    public static class PushScreenSaverModel {
        public String imageUrl;
        public String imageFileName;
        public int index;
        public boolean convertToGrayScale = true;

        public boolean isAllSet() {
            return this.index < 0;
        }
    }
}

