/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import android.os.Handler;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.common.request.BaseRequest;
import com.onyx.android.sdk.common.request.RequestManager;
import com.onyx.android.sdk.data.request.cloud.BaseStatisticsRequest;

public class StatisticsCloudManager {
    private RequestManager requestManager = new RequestManager(5);

    public void acquireWakeLock(Context context, String tag) {
        this.requestManager.acquireWakeLock(context, tag);
    }

    public void releaseWakeLock() {
        this.requestManager.releaseWakeLock();
    }

    private final Runnable generateRunnable(final BaseStatisticsRequest request) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    request.beforeExecute(StatisticsCloudManager.this);
                    request.execute(StatisticsCloudManager.this);
                }
                catch (Throwable tr) {
                    request.setException(tr);
                }
                finally {
                    request.afterExecute(StatisticsCloudManager.this);
                    StatisticsCloudManager.this.requestManager.dumpWakelocks();
                    StatisticsCloudManager.this.requestManager.removeRequest((BaseRequest)request);
                }
            }
        };
        return runnable;
    }

    public boolean submitRequest(Context context, BaseStatisticsRequest request, BaseCallback callback) {
        Runnable runnable = this.generateRunnable(request);
        return this.requestManager.submitRequest(context, (BaseRequest)request, runnable, callback);
    }

    public Handler getLooperHandler() {
        return this.requestManager.getLooperHandler();
    }
}

