/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import com.onyx.android.sdk.data.common.ContentException;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.utils.CollectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class QueryResult<T>
implements Serializable {
    public List<T> list;
    public long count;
    public int fetchSource;
    public ContentException exception;

    public QueryResult<T> copy(int limit) {
        QueryResult<T> result = new QueryResult<T>();
        result.count = this.count;
        result.fetchSource = this.fetchSource;
        result.list = new ArrayList<T>();
        for (int i = 0; i < CollectionUtils.getSize(this.list) && i < limit; ++i) {
            result.list.add(this.list.get(i));
        }
        return result;
    }

    public boolean isFetchFromCloud() {
        return this.fetchSource == Metadata.FetchSource.CLOUD;
    }

    public boolean isContentEmpty() {
        return this.count <= 0L || CollectionUtils.isNullOrEmpty(this.list);
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public void setException(ContentException e) {
        this.exception = e;
    }

    public static boolean isValidQueryResult(QueryResult result) {
        return result != null && !result.isContentEmpty();
    }
}

