/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QueryArgs
implements Serializable {
    private static final String TAG = QueryArgs.class.getSimpleName();
    public static int CLOUD_FETCH_LIMIT = 50;
    public int offset = 0;
    public int limit = Integer.MAX_VALUE;
    @JSONField(serialize=false, deserialize=false)
    public ConditionGroup conditionGroup = ConditionGroup.clause();
    @JSONField(serialize=false, deserialize=false)
    public List<IProperty> propertyList = new ArrayList<IProperty>();
    @JSONField(serialize=false, deserialize=false)
    public List<OrderBy> orderByList = new ArrayList<OrderBy>();
    public String libraryUniqueId = null;
    public BookFilter filter = BookFilter.ALL;
    public SortBy sortBy = SortBy.Name;
    public SortOrder order = SortOrder.Desc;
    public Set<String> fileType = new HashSet<String>();
    public Set<String> author = new HashSet<String>();
    public Set<String> title = new HashSet<String>();
    public Set<String> tags = new HashSet<String>();
    public Set<String> series = new HashSet<String>();
    public Set<String> category = new HashSet<String>();
    public String query;
    public int fetchPolicy = 4;
    public String cloudToken;
    public static final String DEVICE_LIBRARY = "deviceLibrary";
    public static final String RECENT_READ = "recentRead";
    public static final String RECENT_ADDED = "recentAdded";

    public QueryArgs() {
    }

    public QueryArgs(SortBy sortBy, SortOrder order) {
        if (sortBy != null) {
            this.sortBy = sortBy;
        }
        if (order != null) {
            this.order = order;
        }
    }

    public static QueryArgs queryBy(ConditionGroup conditionGroup, OrderBy orderBy) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.conditionGroup = conditionGroup;
        queryArgs.orderByList.add(orderBy);
        return queryArgs;
    }

    public static QueryArgs queryBy(ConditionGroup conditionGroup, List<OrderBy> orderByList) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.conditionGroup = conditionGroup;
        queryArgs.orderByList.addAll(orderByList);
        return queryArgs;
    }

    public static QueryArgs queryBy(ConditionGroup conditionGroup, OrderBy orderBy, int offset, int limit) {
        QueryArgs queryArgs = QueryArgs.queryBy(conditionGroup, orderBy);
        queryArgs.offset = offset;
        queryArgs.limit = limit;
        return queryArgs;
    }

    public static QueryArgs queryBy(ConditionGroup conditionGroup, List<OrderBy> orderByList, int offset, int limit) {
        QueryArgs queryArgs = QueryArgs.queryBy(conditionGroup, orderByList);
        queryArgs.offset = offset;
        queryArgs.limit = limit;
        return queryArgs;
    }

    public static QueryArgs queryBy(ConditionGroup conditionGroup) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.conditionGroup = conditionGroup;
        return queryArgs;
    }

    public QueryArgs appendOrderBy(OrderBy orderBy) {
        this.orderByList.add(orderBy);
        return this;
    }

    public QueryArgs andWith(ConditionGroup otherGroup) {
        this.conditionGroup.and((SQLCondition)otherGroup);
        return this;
    }

    public QueryArgs orWith(ConditionGroup otherGroup) {
        this.conditionGroup.or((SQLCondition)otherGroup);
        return this;
    }

    public QueryArgs appendFilter(BookFilter filter) {
        this.filter = filter;
        return this;
    }

    public static final QueryArgs fromQueryString(String string) {
        QueryArgs args = null;
        try {
            args = (QueryArgs)JSON.parseObject((String)string, QueryArgs.class);
            return args;
        }
        catch (Exception exception) {}
        finally {
            return args;
        }
    }

    public static final String toQueryString(QueryArgs args) {
        return JSON.toJSONString((Object)args);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof QueryArgs)) {
            return false;
        }
        QueryArgs queryCriteria = (QueryArgs)object;
        if (!CollectionUtils.equals(queryCriteria.fileType, this.fileType)) {
            return false;
        }
        if (!CollectionUtils.equals(queryCriteria.title, this.title)) {
            return false;
        }
        if (!CollectionUtils.equals(queryCriteria.author, this.author)) {
            return false;
        }
        if (!CollectionUtils.equals(queryCriteria.tags, this.tags)) {
            return false;
        }
        return CollectionUtils.equals(queryCriteria.series, this.series);
    }

    @JSONField(serialize=false, deserialize=false)
    public boolean isAllSetContentEmpty() {
        if (!CollectionUtils.isNullOrEmpty(this.fileType)) {
            return false;
        }
        if (!CollectionUtils.isNullOrEmpty(this.title)) {
            return false;
        }
        if (!CollectionUtils.isNullOrEmpty(this.author)) {
            return false;
        }
        if (!CollectionUtils.isNullOrEmpty(this.tags)) {
            return false;
        }
        return CollectionUtils.isNullOrEmpty(this.series);
    }

    @JSONField(serialize=false, deserialize=false)
    public String getOrderByQuery() {
        if (CollectionUtils.isNullOrEmpty(this.orderByList)) {
            return null;
        }
        String orderBy = "";
        for (OrderBy by : this.orderByList) {
            orderBy = orderBy + by.getQuery();
        }
        return orderBy;
    }

    @JSONField(serialize=false, deserialize=false)
    public String getLimitOffsetQuery() {
        return " LIMIT " + this.limit + " OFFSET " + this.offset + " ";
    }

    @JSONField(serialize=false, deserialize=false)
    public String getOrderByQueryWithLimitOffset() {
        String orderByQuery = this.getOrderByQuery();
        String limitOffsetQuery = this.getLimitOffsetQuery();
        if (StringUtils.isNullOrEmpty((String)orderByQuery)) {
            Log.w((String)TAG, (String)"NULL orderBy detected, offset and limit does not work.");
            return null;
        }
        return orderByQuery + limitOffsetQuery;
    }

    @JSONField(serialize=false, deserialize=false)
    public String[] getProjectionSet() {
        if (CollectionUtils.isNullOrEmpty(this.propertyList)) {
            return null;
        }
        String[] projection = new String[this.propertyList.size()];
        for (int i = 0; i < this.propertyList.size(); ++i) {
            projection[i] = this.propertyList.get(i).getQuery();
        }
        return projection;
    }

    @JSONField(serialize=false, deserialize=false)
    public int getCloudFetchLimit() {
        return this.limit > CLOUD_FETCH_LIMIT ? this.limit : CLOUD_FETCH_LIMIT;
    }

    public void resetOffset() {
        this.offset = 0;
    }

    public void useMemCloudDbPolicy() {
        this.fetchPolicy = 4;
    }

    public void useCloudMemDbPolicy() {
        this.fetchPolicy = 2;
    }

    public void useCloudOnlyPolicy() {
        this.fetchPolicy = 0;
    }
}

