/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloader;
import com.liulishuo.filedownloader.notification.FileDownloadNotificationHelper;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.data.request.cloud.CloudFileDownloadRequest;
import com.onyx.android.sdk.data.utils.DownloadListener;
import com.onyx.android.sdk.data.utils.NotificationItem;
import java.util.LinkedHashMap;

public class OnyxDownloadManager {
    private static int DEFAULT_PROGRESS_MIN_INTERVAL = 1200;
    private static OnyxDownloadManager instance;
    private static Context appContext;
    private FileDownloadNotificationHelper<NotificationItem> helper = new FileDownloadNotificationHelper();
    private LinkedHashMap<Object, BaseDownloadTask> taskMap = new LinkedHashMap();

    private OnyxDownloadManager() {
    }

    public static void init(Context context) {
        appContext = context;
        FileDownloader.init((Context)appContext);
        FileDownloader.getImpl().setMaxNetworkThreadCount(5);
    }

    public static synchronized OnyxDownloadManager getInstance() {
        if (instance == null) {
            instance = new OnyxDownloadManager();
        }
        return instance;
    }

    public static synchronized Context getContext() {
        return FileDownloadHelper.getAppContext();
    }

    public CloudFileDownloadRequest createDownloadRequest(String url, String path, Object tag) {
        CloudFileDownloadRequest request = new CloudFileDownloadRequest(url, path, tag);
        request.setTaskId(FileDownloadUtils.generateId((String)url, (String)path));
        return request;
    }

    public DownloadListener createDownloadListener(CloudFileDownloadRequest request, BaseCallback baseCallback) {
        return new DownloadListener(request, baseCallback, this.helper);
    }

    public DownloadListener createDownloadListener(NotificationItem.NotificationBean bean, CloudFileDownloadRequest request, BaseCallback baseCallback) {
        DownloadListener listener = this.createDownloadListener(request, baseCallback);
        listener.setNotificationBean(bean);
        return listener;
    }

    public BaseDownloadTask download(Context context, String url, String path, Object tag, BaseCallback baseCallback) {
        CloudFileDownloadRequest request = this.createDownloadRequest(url, path, tag);
        request.setContext(context);
        return this.download(request, baseCallback);
    }

    public BaseDownloadTask download(CloudFileDownloadRequest request, BaseCallback baseCallback) {
        request.setTaskId(FileDownloadUtils.generateId((String)request.getUrl(), (String)request.getPath()));
        BaseDownloadTask task = FileDownloader.getImpl().create(request.getUrl()).setPath(request.getPath()).setTag(request.getTag());
        task.setListener((FileDownloadListener)this.createDownloadListener(request, baseCallback));
        return task;
    }

    public BaseDownloadTask downloadWithNotify(String url, String path, Object tag, NotificationItem.NotificationBean bean, BaseCallback callback) {
        CloudFileDownloadRequest request = this.createDownloadRequest(url, path, tag);
        DownloadListener listener = this.createDownloadListener(bean, request, callback);
        BaseDownloadTask task = FileDownloader.getImpl().create(request.getUrl()).setPath(request.getPath()).setTag(request.getTag());
        task.setListener((FileDownloadListener)listener);
        return task;
    }

    public BaseDownloadTask downloadWithNotify(CloudFileDownloadRequest request, NotificationItem.NotificationBean bean, BaseCallback callback) {
        BaseDownloadTask task = FileDownloader.getImpl().create(request.getUrl()).setPath(request.getPath()).setTag(request.getTag());
        request.setTaskId(FileDownloadUtils.generateId((String)request.getUrl(), (String)request.getPath()));
        DownloadListener listener = this.createDownloadListener(bean, request, callback);
        task.setListener((FileDownloadListener)listener);
        return task;
    }

    public int downloadDirectly(Context context, String url, String path, Object tag, BaseCallback baseCallback) {
        return this.startDownload(this.download(context, url, path, tag, baseCallback));
    }

    public int downloadDirectly(CloudFileDownloadRequest request, BaseCallback baseCallback) {
        return this.startDownload(this.download(request, baseCallback));
    }

    public int startDownload(BaseDownloadTask task) {
        task.setCallbackProgressMinInterval(DEFAULT_PROGRESS_MIN_INTERVAL);
        return task.start();
    }

    public int startDownload(BaseDownloadTask task, int progressMinInterval) {
        task.setCallbackProgressMinInterval(progressMinInterval);
        return task.start();
    }

    public void removeTask(Object key) {
        this.taskMap.remove(key);
    }

    public void addTask(Object key, BaseDownloadTask task) {
        this.taskMap.put(key, task);
    }

    public BaseDownloadTask getTask(Object key) {
        return this.taskMap.get(key);
    }

    public void clearTaskQueue() {
        this.taskMap.clear();
    }

    public int getTaskProgress(int taskId) {
        return (int)((float)FileDownloader.getImpl().getSoFar(taskId) * 1.0f / (float)FileDownloader.getImpl().getTotal(taskId) * 100.0f);
    }

    public int getTaskStatus(int taskId, String path) {
        return FileDownloader.getImpl().getStatus(taskId, path);
    }
}

