/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.LibraryDataModel;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryPagination;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.utils.QueryBuilder;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LibraryViewInfo
implements Serializable {
    private int queryLimit = 9;
    private QueryArgs queryArgs;
    private QueryPagination queryPagination = QueryPagination.create(3, 3);
    private LibraryDataModel libraryDataModel = new LibraryDataModel();
    private List<Library> libraryPath = new ArrayList<Library>();

    public LibraryViewInfo() {
        this.queryArgs = new QueryArgs();
        this.queryArgs.limit = this.queryLimit;
        this.queryPagination.setCurrentPage(0);
    }

    public static LibraryViewInfo create(int rows, int cols) {
        return new LibraryViewInfo(rows, cols, SortBy.Name, SortOrder.Asc);
    }

    public LibraryViewInfo(int row, int col, SortBy sortBy, SortOrder sortOrder) {
        this.queryArgs = new QueryArgs();
        this.queryArgs.limit = this.queryLimit = row * col;
        this.queryPagination.resize(row, col, 0);
        this.queryPagination.setCurrentPage(0);
        this.updateSortBy(sortBy, sortOrder);
    }

    public int getOffset(int currentPage) {
        LibraryDataModel libraryDataModel = this.getLibraryDataModel();
        int itemsPerPage = this.queryPagination.itemsPerPage();
        int offset = currentPage * itemsPerPage - libraryDataModel.libraryCount;
        if (offset < 0) {
            offset = currentPage <= libraryDataModel.libraryCount / itemsPerPage ? 0 : itemsPerPage + offset;
        }
        return offset;
    }

    public int getOffset() {
        return this.getOffset(this.queryPagination.getCurrentPage());
    }

    public QueryArgs nextPage() {
        this.queryArgs.offset = this.getOffset();
        return this.queryArgs;
    }

    public QueryArgs prevPage() {
        this.queryArgs.offset = this.getOffset();
        return this.queryArgs;
    }

    public QueryArgs pageQueryArgs(int page) {
        QueryArgs args = new QueryArgs(this.queryArgs.sortBy, this.queryArgs.order);
        args.limit = this.queryArgs.limit;
        args.offset = this.getOffset(page);
        args.orderByList.addAll(this.queryArgs.orderByList);
        args.conditionGroup = this.queryArgs.conditionGroup;
        args.libraryUniqueId = this.queryArgs.libraryUniqueId;
        args.category = this.queryArgs.category;
        return args;
    }

    public QueryArgs gotoPage(int page) {
        this.queryPagination.setCurrentPage(page);
        this.queryArgs.offset = this.getOffset(page);
        return this.queryArgs;
    }

    public QueryArgs firstPage() {
        return this.gotoPage(0);
    }

    public QueryArgs lastPage() {
        return this.gotoPage(this.queryPagination.lastPage());
    }

    public String getSdcardCid() {
        return EnvironmentUtil.getRemovableSDCardCid();
    }

    private ConditionGroup storageIdCondition() {
        ConditionGroup conditionGroup = ConditionGroup.clause().or((SQLCondition)Metadata_Table.storageId.isNull());
        String cid = this.getSdcardCid();
        if (StringUtils.isNotBlank((String)cid)) {
            conditionGroup.or((SQLCondition)Metadata_Table.storageId.is((Object)cid));
        }
        return conditionGroup;
    }

    public QueryArgs generateMetadataInQueryArgs(QueryArgs queryArgs) {
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public QueryArgs generateQueryArgs(QueryArgs queryArgs) {
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public QueryArgs libraryQuery(int limit, int offset) {
        QueryArgs args = this.libraryQuery(this.getLibraryIdString());
        args.limit = limit;
        args.offset = offset;
        return args;
    }

    public QueryArgs libraryQuery(String libraryId) {
        QueryArgs args = this.buildLibraryQuery(libraryId);
        this.updateQueryArgs(args);
        return args;
    }

    public QueryArgs buildLibraryQuery(String libraryId) {
        QueryArgs args = new QueryArgs(this.queryArgs.sortBy, this.queryArgs.order).appendFilter(this.queryArgs.filter);
        args.limit = this.queryLimit;
        args.offset = 0;
        args.libraryUniqueId = libraryId;
        this.generateQueryArgs(args);
        QueryBuilder.andWith(args.conditionGroup, this.storageIdCondition());
        return this.generateMetadataInQueryArgs(args);
    }

    public QueryArgs libraryQuery() {
        return this.libraryQuery(this.queryArgs.limit, 0);
    }

    public QueryArgs getCurrentQueryArgs() {
        return this.queryArgs;
    }

    public void updateQueryArgs(QueryArgs args) {
        this.queryArgs = args;
    }

    public LibraryDataModel getLibraryDataModel() {
        return this.libraryDataModel;
    }

    public void setLibraryDataModel(LibraryDataModel libraryDataModel) {
        this.clearThumbnailMap(this.getLibraryDataModel());
        this.libraryDataModel = libraryDataModel;
    }

    public LibraryDataModel getPageLibraryDataModel(LibraryDataModel dataModel) {
        this.setLibraryDataModel(dataModel);
        LibraryDataModel pageDataModel = new LibraryDataModel();
        int currentPage = this.queryPagination.getCurrentPage();
        int itemsPerPage = this.queryPagination.itemsPerPage();
        if (currentPage > this.libraryDataModel.libraryCount / itemsPerPage) {
            pageDataModel.visibleLibraryList = new ArrayList<Library>();
            pageDataModel.visibleBookList = this.libraryDataModel.visibleBookList;
        } else {
            int position;
            for (int i = position = currentPage * itemsPerPage; i < this.libraryDataModel.libraryCount && i < (currentPage + 1) * itemsPerPage; ++i) {
                pageDataModel.visibleLibraryList.add(this.libraryDataModel.visibleLibraryList.get(i));
            }
            int size = itemsPerPage - CollectionUtils.getSize(pageDataModel.visibleLibraryList);
            for (int i = 0; i < size && i < CollectionUtils.getSize(this.libraryDataModel.visibleBookList); ++i) {
                pageDataModel.visibleBookList.add(this.libraryDataModel.visibleBookList.get(i));
            }
        }
        pageDataModel.bookCount = this.libraryDataModel.bookCount;
        pageDataModel.libraryCount = this.libraryDataModel.libraryCount;
        pageDataModel.thumbnailMap = this.libraryDataModel.thumbnailMap;
        return pageDataModel;
    }

    public QueryPagination getQueryPagination() {
        return this.queryPagination;
    }

    public void setQueryPagination(QueryPagination queryPagination) {
        this.queryPagination = queryPagination;
    }

    public String getLibraryIdString() {
        if (CollectionUtils.isNullOrEmpty(this.libraryPath)) {
            return null;
        }
        return this.libraryPath.get(this.libraryPath.size() - 1).getIdString();
    }

    public List<Library> getLibraryPathList() {
        return this.libraryPath;
    }

    public void setLibraryPathList(List<Library> newPathList) {
        this.libraryPath = newPathList;
    }

    public void setCurrentSortOrder(SortOrder sortOrder) {
        this.queryArgs.order = sortOrder;
    }

    public SortOrder getCurrentSortOrder() {
        return this.queryArgs.order;
    }

    public void updateSortBy(SortBy sortBy, SortOrder sortOrder) {
        this.queryArgs.sortBy = sortBy;
        this.queryArgs.order = sortOrder;
    }

    public void updateFilterBy(BookFilter filter, SortOrder sortOrder) {
        this.queryArgs.filter = filter;
        this.queryArgs.order = sortOrder;
    }

    public void setQueryLimit(int limit) {
        this.queryArgs.limit = this.queryLimit = limit;
    }

    public int getQueryLimit() {
        return this.queryLimit;
    }

    public void clearThumbnailMap(LibraryDataModel dataModel) {
        if (dataModel == null || CollectionUtils.isNullOrEmpty(dataModel.thumbnailMap)) {
            return;
        }
        for (CloseableReference<Bitmap> refBitmap : dataModel.thumbnailMap.values()) {
            refBitmap.close();
        }
    }

    public static LibraryDataModel buildLibraryDataModel(QueryResult<Metadata> result, Map<String, CloseableReference<Bitmap>> map) {
        LibraryDataModel libraryDataModel = new LibraryDataModel();
        if (result == null) {
            return libraryDataModel;
        }
        libraryDataModel.visibleLibraryList = new ArrayList<Library>();
        libraryDataModel.visibleBookList = result.list;
        libraryDataModel.bookCount = (int)result.count;
        libraryDataModel.thumbnailMap = map;
        libraryDataModel.libraryCount = 0;
        return libraryDataModel;
    }
}

