/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.OnyxDownloadManager;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.CloudConf;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowManager;

public class CloudStore {
    private CloudManager requestManager = new CloudManager();

    public static void init(Context appContext) {
        CloudStore.initDatabase(appContext);
        CloudStore.initFileDownloader(appContext);
    }

    public static void terminate() {
        CloudStore.terminateCloudDatabase();
    }

    public boolean submitRequest(Context context, BaseCloudRequest request, BaseCallback callback) {
        return this.requestManager.submitRequest(context, request, callback);
    }

    public boolean submitRequestToSingle(Context context, BaseCloudRequest request, BaseCallback callback) {
        return this.requestManager.submitRequestToSingle(context, request, callback);
    }

    public final CloudConf getCloudConf() {
        return this.requestManager.getCloudConf();
    }

    private static void initDatabase(Context context) {
        try {
            FlowConfig.Builder builder = new FlowConfig.Builder(context);
            FlowManager.init((FlowConfig)builder.build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static OnyxDownloadManager initFileDownloader(Context context) {
        OnyxDownloadManager.init(context);
        return OnyxDownloadManager.getInstance();
    }

    private static void terminateCloudDatabase() {
        FlowManager.destroy();
    }

    public CloudManager getCloudManager() {
        return this.requestManager;
    }

    public CloudStore setCloudConf(CloudConf cloudConf) {
        this.getCloudManager().setAllCloudConf(cloudConf);
        return this;
    }

    public static CloudManager createCloudManager(CloudConf cloudConf) {
        return new CloudStore().setCloudConf(cloudConf).getCloudManager();
    }
}

