/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.v2.CloudMetadataCollection;
import com.onyx.android.sdk.data.model.v2.CloudMetadataCollection_Table;
import com.onyx.android.sdk.data.model.v2.CloudMetadata_Table;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.BaseProperty;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.IntProperty;
import com.raizlabs.android.dbflow.sql.language.property.LongProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class CloudQueryBuilder {
    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = CloudQueryBuilder.allBooksQuery(sortBy, sortOrder);
        args.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, Set<String> fileTypes, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = CloudQueryBuilder.allBooksQuery(fileTypes, sortBy, sortOrder);
        args.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, Set<String> fileTypes, OrderBy orderBy) {
        QueryArgs args = QueryArgs.queryBy(CloudQueryBuilder.orTypeCondition(fileTypes), orderBy);
        args.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryBookListNewQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = CloudQueryBuilder.newBookListQuery(sortBy, sortOrder);
        args.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryFinishReadQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = CloudQueryBuilder.finishReadQuery(sortBy, sortOrder);
        args.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryRecentReadingQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = CloudQueryBuilder.recentReadingQuery(sortBy, sortOrder);
        args.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryRecentAddQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = new QueryArgs(sortBy, sortOrder);
        args.libraryUniqueId = libraryUniqueId;
        args.conditionGroup = CloudQueryBuilder.recentAddCondition();
        return CloudQueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs libraryTagsFilterQuery(String libraryUniqueId, Set<String> tags, SortBy sortBy, SortOrder order) {
        QueryArgs args = CloudQueryBuilder.tagsFilterQuery(tags, sortBy, order);
        args.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs librarySearchQuery(String libraryUniqueId, String search, SortBy sortBy, SortOrder order) {
        QueryArgs args = CloudQueryBuilder.searchQuery(search, sortBy, order);
        args.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(args);
    }

    public static QueryArgs allBooksQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.ALL);
        return CloudQueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs allBooksQuery(Set<String> fileTypes, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.ALL);
        args.fileType = fileTypes;
        return CloudQueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs allBooksQuery(Set<String> fileTypes, OrderBy orderBy) {
        return QueryArgs.queryBy(CloudQueryBuilder.orTypeCondition(fileTypes), orderBy);
    }

    public static QueryArgs newBookListQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.NEW);
        return CloudQueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs finishReadQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.FINISHED);
        return CloudQueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs recentReadingQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs args = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.READING);
        return CloudQueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs tagsFilterQuery(Set<String> tags, SortBy sortBy, SortOrder order) {
        QueryArgs args = new QueryArgs(sortBy, order).appendFilter(BookFilter.TAG);
        args.tags = tags;
        return CloudQueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs searchQuery(String search, SortBy sortBy, SortOrder order) {
        QueryArgs args = new QueryArgs(sortBy, order).appendFilter(BookFilter.SEARCH);
        args.query = search;
        return CloudQueryBuilder.generateQueryArgs(args);
    }

    public static QueryArgs recentAddQuery() {
        QueryArgs args = QueryArgs.queryBy(CloudQueryBuilder.recentAddCondition(), CloudQueryBuilder.getOrderByUpdateAt().descending());
        return args;
    }

    public static IntProperty getMetadataReadingStatusProperty() {
        return CloudMetadata_Table.readingStatus;
    }

    public static Property<String> getMetadataTypeProperty() {
        return CloudMetadata_Table.type;
    }

    public static Property<String> getMetadataTitleProperty() {
        return CloudMetadata_Table.title;
    }

    public static Property<String> getMetadataNameProperty() {
        return CloudMetadata_Table.name;
    }

    public static Property<String> getMetadataAuthorsProperty() {
        return CloudMetadata_Table.authors;
    }

    public static Property<String> getMetadataPublisherProperty() {
        return CloudMetadata_Table.publisher;
    }

    public static Property<String> getMetadataTagsProperty() {
        return CloudMetadata_Table.tags;
    }

    public static Property<String> getMetadataSeriesProperty() {
        return CloudMetadata_Table.series;
    }

    public static Property<String> getMetadataIdStringProperty() {
        return CloudMetadata_Table.idString;
    }

    public static Property<String> getMetadataCloudIdProperty() {
        return CloudMetadata_Table.cloudId;
    }

    public static LongProperty getMetadataSizeProperty() {
        return CloudMetadata_Table.size;
    }

    public static Property<Date> getMetadataCreatedAtProperty() {
        return CloudMetadata_Table.createdAt;
    }

    public static Property<Date> getMetadataLastAccessProperty() {
        return CloudMetadata_Table.lastAccess;
    }

    public static Property<String> getMetadataCollectionDocIdProperty() {
        return CloudMetadataCollection_Table.documentUniqueId;
    }

    public static Property<String> getMetadataCollectionLibraryIdProperty() {
        return CloudMetadataCollection_Table.libraryUniqueId;
    }

    public static ConditionGroup newBookListCondition() {
        return ConditionGroup.clause().and((SQLCondition)CloudQueryBuilder.getMetadataReadingStatusProperty().eq(Metadata.ReadingStatus.NEW));
    }

    public static ConditionGroup finishReadCondition() {
        return ConditionGroup.clause().and((SQLCondition)CloudQueryBuilder.getMetadataReadingStatusProperty().eq(Metadata.ReadingStatus.FINISHED));
    }

    public static ConditionGroup recentReadingCondition() {
        return ConditionGroup.clause().and((SQLCondition)CloudQueryBuilder.getMetadataReadingStatusProperty().eq(Metadata.ReadingStatus.READING));
    }

    public static ConditionGroup recentAddCondition() {
        return ConditionGroup.clause().and((SQLCondition)CloudQueryBuilder.getMetadataReadingStatusProperty().eq(Metadata.ReadingStatus.NEW));
    }

    public static ConditionGroup orTypeCondition(Set<String> fileTypes) {
        if (CollectionUtils.isNullOrEmpty(fileTypes)) {
            return ConditionGroup.clause();
        }
        ConditionGroup group = ConditionGroup.clause();
        ArrayList<Condition> sqlConditions = new ArrayList<Condition>();
        for (String type : fileTypes) {
            sqlConditions.add(CloudQueryBuilder.getMetadataTypeProperty().eq((Object)type));
        }
        return group.orAll(sqlConditions);
    }

    public static ConditionGroup orTagsCondition(Set<String> tags) {
        if (CollectionUtils.isNullOrEmpty(tags)) {
            return ConditionGroup.clause();
        }
        ArrayList<Condition> sqlConditions = new ArrayList<Condition>();
        for (String tag : tags) {
            sqlConditions.add(CloudQueryBuilder.matchLike(CloudQueryBuilder.getMetadataTagsProperty(), tag));
        }
        return ConditionGroup.clause().orAll(sqlConditions);
    }

    public static ConditionGroup orSearchCondition(String search) {
        if (StringUtils.isNullOrEmpty((String)search)) {
            return ConditionGroup.clause();
        }
        return ConditionGroup.clause().or((SQLCondition)CloudQueryBuilder.matchLike(CloudQueryBuilder.getMetadataTitleProperty(), search)).or((SQLCondition)CloudQueryBuilder.matchLike(CloudQueryBuilder.getMetadataNameProperty(), search)).or((SQLCondition)CloudQueryBuilder.matchLike(CloudQueryBuilder.getMetadataAuthorsProperty(), search));
    }

    public static List<OrderBy> getOrderByList() {
        ArrayList<OrderBy> orderByList = new ArrayList<OrderBy>();
        orderByList.add(OrderBy.fromProperty(CloudQueryBuilder.getMetadataNameProperty()).ascending());
        return orderByList;
    }

    public static OrderBy getOrderByUpdateAt() {
        return CloudQueryBuilder.getOrderBy(CloudQueryBuilder.getMetadataCreatedAtProperty());
    }

    public static OrderBy getOrderByCreateAt() {
        return CloudQueryBuilder.getOrderBy(CloudQueryBuilder.getMetadataCreatedAtProperty());
    }

    public static OrderBy getOrderByName() {
        return CloudQueryBuilder.getOrderBy(CloudQueryBuilder.getMetadataNameProperty()).ascending();
    }

    public static OrderBy getOrderBy(IProperty property) {
        return OrderBy.fromProperty((IProperty)property);
    }

    public static void andWith(ConditionGroup parent, ConditionGroup child) {
        if (parent != null && child != null) {
            parent.and((SQLCondition)child);
        }
    }

    public static Condition matchLike(Property<String> property, String match) {
        if (StringUtils.isNullOrEmpty((String)match)) {
            return null;
        }
        return property.like("%" + match + "%");
    }

    public static ConditionGroup matchLikeSet(Property<String> property, Set<String> set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        ConditionGroup conditionGroup = ConditionGroup.clause();
        for (String string : set) {
            Condition condition = CloudQueryBuilder.matchLike(property, string);
            if (condition == null) continue;
            conditionGroup.or((SQLCondition)condition);
        }
        return conditionGroup;
    }

    public static ConditionGroup matchEqualSet(Property<String> property, Set<String> set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        ConditionGroup conditionGroup = ConditionGroup.clause();
        for (String string : set) {
            conditionGroup.or((SQLCondition)property.eq((Object)string));
        }
        return conditionGroup;
    }

    private static Condition getNullOrEqualCondition(Property<String> property, String compare) {
        return compare == null ? property.isNull() : property.eq((Object)compare);
    }

    private static Condition getNotNullOrEqualCondition(Property<String> property, String value) {
        return value == null ? property.isNotNull() : property.eq((Object)value);
    }

    private static Condition.In inCondition(Property property, Where in, boolean isIn) {
        return isIn ? property.in((BaseModelQueriable)in, new BaseModelQueriable[0]) : property.notIn((BaseModelQueriable)in, new BaseModelQueriable[0]);
    }

    public static QueryArgs generateQueryArgs(QueryArgs args) {
        switch (args.filter) {
            case ALL: {
                args.conditionGroup = CloudQueryBuilder.orTypeCondition(args.fileType);
                break;
            }
            case NEW: {
                args.conditionGroup = CloudQueryBuilder.newBookListCondition();
                break;
            }
            case READING: {
                args.conditionGroup = CloudQueryBuilder.recentReadingCondition();
                break;
            }
            case FINISHED: {
                args.conditionGroup = CloudQueryBuilder.finishReadCondition();
                break;
            }
            case TAG: {
                args.conditionGroup = CloudQueryBuilder.orTagsCondition(args.tags);
                break;
            }
            case SEARCH: {
                args.conditionGroup = CloudQueryBuilder.orSearchCondition(args.query);
            }
        }
        CloudQueryBuilder.generateQueryArgsSortBy(args);
        CloudQueryBuilder.generateCriteriaCondition(args);
        return args;
    }

    private static OrderBy ascDescOrder(OrderBy orderBy, boolean asc) {
        if (asc) {
            orderBy.ascending();
        } else {
            orderBy.descending();
        }
        return orderBy;
    }

    public static BaseProperty getPropertyFromSortBy(SortBy sortBy) {
        Object property = CloudQueryBuilder.getMetadataNameProperty();
        switch (sortBy) {
            case None: 
            case Name: {
                break;
            }
            case FileType: {
                property = CloudQueryBuilder.getMetadataTypeProperty();
                break;
            }
            case Size: {
                property = CloudQueryBuilder.getMetadataSizeProperty();
                break;
            }
            case CreationTime: {
                property = CloudQueryBuilder.getMetadataCreatedAtProperty();
                break;
            }
            case BookTitle: {
                property = CloudQueryBuilder.getMetadataTitleProperty();
                break;
            }
            case Author: {
                property = CloudQueryBuilder.getMetadataAuthorsProperty();
                break;
            }
            case Publisher: {
                property = CloudQueryBuilder.getMetadataPublisherProperty();
                break;
            }
            case LastOpenTime: {
                property = CloudQueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case RecentlyRead: {
                property = CloudQueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case Total: {
                property = CloudQueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case StartTime: {
                property = CloudQueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case InstallTime: {
                property = CloudQueryBuilder.getMetadataLastAccessProperty();
            }
        }
        return property;
    }

    public static OrderBy generateOrderBy(SortBy sortBy, SortOrder order) {
        boolean asc = order == SortOrder.Asc;
        return CloudQueryBuilder.ascDescOrder(OrderBy.fromProperty((IProperty)CloudQueryBuilder.getPropertyFromSortBy(sortBy)), asc);
    }

    public static void generateQueryArgsSortBy(QueryArgs args) {
        args.orderByList.clear();
        args.orderByList.add(CloudQueryBuilder.generateOrderBy(args.sortBy, args.order));
    }

    public static void generateCriteriaCondition(QueryArgs args) {
        CloudQueryBuilder.andWith(args.conditionGroup, CloudQueryBuilder.matchLikeSet(CloudQueryBuilder.getMetadataAuthorsProperty(), args.author));
        CloudQueryBuilder.andWith(args.conditionGroup, CloudQueryBuilder.matchLikeSet(CloudQueryBuilder.getMetadataTagsProperty(), args.tags));
        CloudQueryBuilder.andWith(args.conditionGroup, CloudQueryBuilder.matchLikeSet(CloudQueryBuilder.getMetadataSeriesProperty(), args.series));
        CloudQueryBuilder.andWith(args.conditionGroup, CloudQueryBuilder.matchLikeSet(CloudQueryBuilder.getMetadataTitleProperty(), args.title));
        CloudQueryBuilder.andWith(args.conditionGroup, CloudQueryBuilder.matchLikeSet(CloudQueryBuilder.getMetadataTypeProperty(), args.fileType));
    }

    public static QueryArgs generateMetadataInQueryArgs(QueryArgs queryArgs) {
        Where whereCollection = new Select(new IProperty[]{CloudQueryBuilder.getMetadataCollectionDocIdProperty().withTable()}).from(CloudMetadataCollection.class).where(new SQLCondition[]{CloudQueryBuilder.getNotNullOrEqualCondition((Property<String>)((Property)CloudQueryBuilder.getMetadataCollectionLibraryIdProperty().withTable()), queryArgs.libraryUniqueId)});
        Condition.In inCondition = CloudQueryBuilder.inCondition((Property)CloudQueryBuilder.getMetadataCloudIdProperty().withTable(), whereCollection, StringUtils.isNotBlank((String)queryArgs.libraryUniqueId));
        ConditionGroup group = ConditionGroup.clause().and((SQLCondition)inCondition);
        queryArgs.conditionGroup = queryArgs.conditionGroup.size() > 0 ? group.and((SQLCondition)queryArgs.conditionGroup) : group;
        return queryArgs;
    }
}

