/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.v1;

import com.onyx.android.sdk.data.model.Category;
import com.onyx.android.sdk.data.model.Comment;
import com.onyx.android.sdk.data.model.DownloadLink;
import com.onyx.android.sdk.data.model.Product;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.model.ProductShared;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface OnyxBookStoreService {
    @GET(value="book/list")
    public Call<ProductResult<Product>> bookList(@Query(value="where") String var1);

    @GET(value="book/{id}")
    public Call<Product> book(@Path(value="id") String var1);

    @GET(value="book/{id}/data")
    public Call<ResponseBody> getBookBytes(@Path(value="id") String var1, @Query(value="format") String var2, @Header(value="X-ONYX-SESSION-TOKEN") String var3);

    @GET(value="book/{id}")
    public Call<Product> getBookByMd5(@Path(value="id") String var1, @Query(value="where") String var2, @Header(value="X-ONYX-SESSION-TOKEN") String var3);

    @GET(value="book/{id}/links")
    public Call<List<DownloadLink>> bookDownloadLink(@Path(value="id") String var1);

    @GET(value="book/list/recommended")
    public Call<ProductResult<Product>> bookRecommendedList(@Query(value="where") String var1);

    @GET(value="book/list/recent")
    public Call<ProductResult<Product>> bookRecentList();

    @GET(value="book/search")
    public Call<ProductResult<Product>> bookSearch(@Query(value="where") String var1);

    @GET(value="category")
    public Call<List<Category>> bookContainerList();

    @GET(value="category/{id}")
    public Call<Category> bookContainer(@Path(value="id") String var1);

    @DELETE(value="book/{id}/data")
    public Call<ResponseBody> deleteBook(@Path(value="id") String var1, @Query(value="format") String var2, @Header(value="X-ONYX-SESSION-TOKEN") String var3);

    @GET(value="book/{id}/{type}/cover")
    public Call<ResponseBody> getBookCover(@Path(value="id") String var1, @Path(value="type") String var2);

    @GET(value="book/{id}/comment/list")
    public Call<ProductResult<Comment>> getBookCommentList(@Path(value="id") String var1, @Query(value="where") String var2);

    @GET(value="book/{pid}/comment/{cid}")
    public Call<Comment> getBookComment(@Path(value="pid") String var1, @Path(value="cid") String var2);

    @POST(value="book/{id}/comment")
    public Call<Comment> postBookComment(@Path(value="id") String var1, @Body Comment var2, @Header(value="X-ONYX-SESSION-TOKEN") String var3);

    @PUT(value="book/{pid}/comment/{cid}")
    public Call<Comment> updateBookComment(@Path(value="pid") String var1, @Path(value="cid") String var2, @Body Comment var3, @Header(value="X-ONYX-SESSION-TOKEN") String var4);

    @DELETE(value="book/{pid}/comment/{cid}")
    public Call<ResponseBody> deleteBookComment(@Path(value="pid") String var1, @Path(value="cid") String var2, @Header(value="X-ONYX-SESSION-TOKEN") String var3);

    @PUT(value="book/{pid}/comment/{cid}/up")
    public Call<Comment> supportBookComment(@Path(value="pid") String var1, @Path(value="cid") String var2, @Header(value="X-ONYX-SESSION-TOKEN") String var3);

    @PUT(value="book/{pid}/comment/{cid}/down")
    public Call<Comment> disagreeBookComment(@Path(value="pid") String var1, @Path(value="cid") String var2, @Header(value="X-ONYX-SESSION-TOKEN") String var3);

    @GET(value="book/share/list")
    public Call<ProductResult<ProductShared>> productSharedList(@Query(value="where") String var1);
}

