/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.app.DownloadManager;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.onyx.android.sdk.utils.FileUtils;

public class DownloadUtils {
    static final String SERVICE = "download";
    private static final String TAG = DownloadUtils.class.getSimpleName();

    public static DownloadManager getDownloadManager(Context context) {
        String serviceString = SERVICE;
        DownloadManager downloadManager = (DownloadManager)context.getSystemService(SERVICE);
        return downloadManager;
    }

    public static long queryReferenceByUrl(Context context, String url) {
        DownloadManager downloadManager = (DownloadManager)context.getSystemService(SERVICE);
        DownloadManager.Query query = new DownloadManager.Query();
        Cursor c = downloadManager.query(query);
        c.moveToFirst();
        long ref = -1L;
        while (!c.isAfterLast()) {
            String uri = c.getString(c.getColumnIndex("uri"));
            if (uri.equalsIgnoreCase(url)) {
                int s = c.getInt(c.getColumnIndex("status"));
                if (s == 16) break;
                ref = c.getInt(c.getColumnIndex("_id"));
                break;
            }
            c.moveToNext();
        }
        c.close();
        return ref;
    }

    public static long download(Context context, String url, String localPath) {
        FileUtils.deleteFile((String)localPath);
        Uri uri = Uri.parse((String)url);
        DownloadManager.Request request = new DownloadManager.Request(uri);
        String destination = String.format("file://%s", localPath);
        Uri dstUri = Uri.parse((String)destination);
        request.setDestinationUri(dstUri);
        request.setAllowedNetworkTypes(2);
        request.setVisibleInDownloadsUi(false);
        return DownloadUtils.getDownloadManager(context).enqueue(request);
    }

    public static void reportState(Context context, long reference, DownloadCallback callback) {
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(new long[]{reference});
        Cursor c = DownloadUtils.getDownloadManager(context).query(query);
        if (c.moveToFirst()) {
            int status = c.getInt(c.getColumnIndex("status"));
            int reason = c.getInt(c.getColumnIndex("reason"));
            switch (status) {
                case 4: {
                    Log.v((String)TAG, (String)"STATUS_PAUSED");
                    break;
                }
                case 1: {
                    Log.v((String)TAG, (String)"STATUS_PENDING");
                    break;
                }
                case 2: {
                    Log.v((String)TAG, (String)"STATUS_RUNNING");
                    break;
                }
                case 8: {
                    Log.v((String)TAG, (String)"Download finished");
                    break;
                }
                case 16: {
                    Log.v((String)TAG, (String)("STATUS_FAILED reason: " + reason));
                }
            }
            long total = c.getInt(c.getColumnIndex("total_size"));
            long bytes = c.getInt(c.getColumnIndex("bytes_so_far"));
            c.close();
            if (callback != null) {
                if (total > 0L) {
                    callback.stateChanged(status, bytes, total, bytes * 100L / total);
                } else {
                    callback.stateChanged(status, bytes, total, 0L);
                }
            }
        }
    }

    public static class DownloadCallback {
        public void stateChanged(int state, long finished, long total, long precentage) {
        }
    }
}

