/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.os.Handler;
import android.os.Looper;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.notification.BaseNotificationItem;
import com.liulishuo.filedownloader.notification.FileDownloadNotificationHelper;
import com.liulishuo.filedownloader.notification.FileDownloadNotificationListener;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.common.request.BaseRequest;
import com.onyx.android.sdk.data.request.cloud.CloudFileDownloadRequest;
import com.onyx.android.sdk.data.utils.NotificationItem;
import com.onyx.android.sdk.utils.StringUtils;

public class DownloadListener
extends FileDownloadNotificationListener {
    private BaseCallback.ProgressInfo progressInfo;
    private CloudFileDownloadRequest downloadRequest;
    private BaseCallback baseCallback;
    private Handler handler = new Handler(Looper.getMainLooper());
    private NotificationItem.NotificationBean bean;

    public DownloadListener(CloudFileDownloadRequest downloadRequest, BaseCallback baseCallback, FileDownloadNotificationHelper helper) {
        super(helper);
        this.downloadRequest = downloadRequest;
        this.baseCallback = baseCallback;
        this.progressInfo = new BaseCallback.ProgressInfo();
    }

    public void setNotificationBean(NotificationItem.NotificationBean bean) {
        this.bean = bean;
    }

    protected BaseNotificationItem create(BaseDownloadTask task) {
        if (this.bean == null) {
            return null;
        }
        this.bean.id = task.getId();
        if (StringUtils.isNullOrEmpty((String)this.bean.title)) {
            this.bean.title = task.getFilename();
        }
        return new NotificationItem(this.bean);
    }

    protected boolean interceptCancel(BaseDownloadTask task, BaseNotificationItem notificationItem) {
        if (this.bean != null) {
            return true;
        }
        return super.interceptCancel(task, notificationItem);
    }

    protected boolean disableNotification(BaseDownloadTask task) {
        if (this.bean == null) {
            return true;
        }
        return super.disableNotification(task);
    }

    public void destroyNotification(BaseDownloadTask task) {
        super.destroyNotification(task);
    }

    protected void pending(BaseDownloadTask task, int soFarBytes, int totalBytes) {
        super.pending(task, soFarBytes, totalBytes);
        this.processUpdate(task);
    }

    protected void started(BaseDownloadTask task) {
        super.started(task);
        this.processStart(task);
    }

    protected void connected(BaseDownloadTask task, String tag, boolean isContinue, int soFarBytes, int totalBytes) {
        super.connected(task, tag, isContinue, soFarBytes, totalBytes);
        this.processUpdate(task);
    }

    protected void progress(BaseDownloadTask task, int soFarBytes, int totalBytes) {
        super.progress(task, soFarBytes, totalBytes);
        this.progressInfo.soFarBytes = soFarBytes;
        this.progressInfo.totalBytes = totalBytes;
        this.progressInfo.progress = (float)soFarBytes * 1.0f * 100.0f / (float)totalBytes;
        this.processUpdate(task);
    }

    protected void blockComplete(BaseDownloadTask task) {
        super.blockComplete(task);
        this.updateDownloadRequest(task);
        this.executeDownloadRequest();
    }

    protected void completed(BaseDownloadTask task) {
        super.completed(task);
        this.processException(task, this.downloadRequest.getException());
    }

    protected void paused(BaseDownloadTask task, int soFarBytes, int totalBytes) {
        super.paused(task, soFarBytes, totalBytes);
        this.processUpdate(task);
    }

    protected void error(BaseDownloadTask task, Throwable e) {
        super.error(task, e);
        this.processException(task, e);
    }

    protected void warn(BaseDownloadTask task) {
        super.warn(task);
        this.processUpdate(task);
    }

    private void processStart(final BaseDownloadTask task) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                DownloadListener.this.updateDownloadRequest(task);
                BaseCallback.invokeStart((BaseCallback)DownloadListener.this.baseCallback, (BaseRequest)DownloadListener.this.downloadRequest);
            }
        });
    }

    private void processException(final BaseDownloadTask task, final Throwable e) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                DownloadListener.this.updateDownloadRequest(task);
                BaseCallback.invoke((BaseCallback)DownloadListener.this.baseCallback, (BaseRequest)DownloadListener.this.downloadRequest, (Throwable)e);
            }
        });
    }

    private void processUpdate(final BaseDownloadTask task) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                DownloadListener.this.updateDownloadRequest(task);
                BaseCallback.invokeProgress((BaseCallback)DownloadListener.this.baseCallback, (BaseRequest)DownloadListener.this.downloadRequest, (BaseCallback.ProgressInfo)DownloadListener.this.progressInfo);
            }
        });
    }

    private void updateDownloadRequest(BaseDownloadTask task) {
        this.downloadRequest.setState(task.getStatus());
        this.downloadRequest.setTaskId(task.getId());
    }

    private void executeDownloadRequest() {
        try {
            this.downloadRequest.execute(null);
        }
        catch (Exception e) {
            this.downloadRequest.setException(e);
            throw new RuntimeException(e);
        }
    }

    public CloudFileDownloadRequest getDownloadRequest() {
        return this.downloadRequest;
    }

    public void setDownloadRequest(CloudFileDownloadRequest request) {
        this.downloadRequest = request;
    }

    public BaseCallback getBaseCallback() {
        return this.baseCallback;
    }

    public void setBaseCallback(BaseCallback callback) {
        this.baseCallback = callback;
    }
}

