/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.db;

import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.request.data.db.BaseDBRequest;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MetadataRequest
extends BaseDBRequest {
    private HashSet<String> pathList = new HashSet();
    private List<Metadata> list = new ArrayList<Metadata>();
    private QueryArgs queryArgs;
    private long count;

    public MetadataRequest(QueryArgs queryArgs) {
        this.queryArgs = queryArgs;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.count = dataManager.getRemoteContentProvider().count(this.getContext(), this.queryArgs);
        this.list.addAll(dataManager.getRemoteContentProvider().findMetadataByQueryArgs(this.getContext(), this.queryArgs));
        this.loadPathList();
    }

    private void loadPathList() {
        if (CollectionUtils.isNullOrEmpty(this.queryArgs.propertyList)) {
            return;
        }
        for (IProperty iProperty : this.queryArgs.propertyList) {
            if (!iProperty.getNameAlias().name().equals(Metadata_Table.nativeAbsolutePath.getNameAlias().name())) continue;
            for (Metadata metadata : this.list) {
                this.pathList.add(metadata.getNativeAbsolutePath());
            }
        }
    }

    public final List<Metadata> getList() {
        return this.list;
    }

    public long getCount() {
        return this.count;
    }

    public final HashSet<String> getPathList() {
        return this.pathList;
    }
}

