/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.db;

import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.request.data.db.BaseDBRequest;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class LibraryMoveToRequest
extends BaseDBRequest {
    private Library fromLibrary;
    private Library toLibrary;
    private List<Metadata> addList = new ArrayList<Metadata>();

    public LibraryMoveToRequest(Library fromLibrary, Library toLibrary, List<Metadata> addList) {
        this.fromLibrary = fromLibrary;
        this.toLibrary = toLibrary;
        this.addList.addAll(addList);
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        String fromIdString = null;
        String toIdString = null;
        if (this.fromLibrary != null) {
            fromIdString = this.fromLibrary.getIdString();
        }
        if (this.toLibrary != null) {
            toIdString = this.toLibrary.getIdString();
        }
        DataProviderBase providerBase = dataManager.getRemoteContentProvider();
        for (Metadata metadata : this.addList) {
            MetadataCollection collection = providerBase.loadMetadataCollection(this.getContext(), fromIdString, metadata.getIdString());
            if (StringUtils.isNullOrEmpty((String)toIdString)) {
                if (collection == null) continue;
                providerBase.deleteMetadataCollection(this.getContext(), fromIdString, metadata.getIdString());
                continue;
            }
            if (collection == null) {
                collection = MetadataCollection.create(metadata.getIdString(), toIdString);
            }
            collection.setLibraryUniqueId(toIdString);
            if (collection.hasValidId()) {
                providerBase.updateMetadataCollection(collection);
                continue;
            }
            providerBase.addMetadataCollection(this.getContext(), collection);
        }
    }
}

