/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.db;

import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.request.data.BaseDataRequest;
import com.onyx.android.sdk.utils.CollectionUtils;
import java.io.File;
import java.util.Set;

public class FilesAddToMetadataRequest
extends BaseDataRequest {
    private String storageId;
    private Set<String> addFiles;

    public FilesAddToMetadataRequest(String storageId, Set<String> addFiles) {
        this.storageId = storageId;
        this.addFiles = addFiles;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        if (CollectionUtils.isNullOrEmpty(this.addFiles)) {
            return;
        }
        for (String filePath : this.addFiles) {
            Metadata metadata;
            File file = new File(filePath);
            if (!file.exists() || (metadata = dataManager.getRemoteContentProvider().findMetadataByPath(this.getContext(), filePath)) != null && metadata.hasValidId()) continue;
            this.createMetadataAndSave(dataManager, file);
        }
    }

    private void createMetadataAndSave(DataManager dataManager, File file) {
        Metadata metadata = Metadata.createFromFile(file, false);
        if (metadata != null) {
            metadata.setStorageId(this.storageId);
            dataManager.getRemoteContentProvider().saveMetadata(this.getContext(), metadata);
        }
    }
}

