/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.model.Link;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.model.PushProduct;
import com.onyx.android.sdk.data.model.PushProduct_Table;
import com.onyx.android.sdk.data.model.PushRecord;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Response;

public class PushRecordListRequest
extends BaseCloudRequest {
    private boolean cloudOnly = false;
    private boolean sync = false;
    private List<PushRecord> recordList = new ArrayList<PushRecord>();
    private List<PushProduct> productList = new ArrayList<PushProduct>();
    private List<Link> linkList = new ArrayList<Link>();

    public PushRecordListRequest(boolean cloud, boolean sync) {
        this.sync = sync;
        this.cloudOnly = cloud;
    }

    public List<PushProduct> getProductList() {
        return this.productList;
    }

    public List<Link> getLinkList() {
        return this.linkList;
    }

    public List<PushRecord> getRecordList() {
        return this.recordList;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (!this.cloudOnly) {
            this.fetchFromLocalCache(parent);
            return;
        }
        if (CloudManager.isWifiConnected(this.getContext())) {
            this.fetchFromCloud(parent);
        } else {
            this.fetchFromLocalCache(parent);
        }
    }

    public void fetchFromLocalCache(CloudManager parent) throws Exception {
        this.productList = this.loadLocalData();
        this.processProductFileExist(this.getContext(), this.productList);
        this.parseLinkList(this.productList, parent.getCloudConf().getCloudStorage());
    }

    public void fetchFromCloud(CloudManager parent) throws Exception {
        ProductResult result;
        Response<ProductResult<PushRecord>> response = this.executeCall(ServiceFactory.getPushService(parent.getCloudConf().getApiBase()).pushRecordList(this.getAccountSessionToken()));
        if (response.isSuccessful() && !StoreUtils.isEmpty(result = (ProductResult)response.body())) {
            this.recordList = result.list;
            for (PushRecord pushRecord : result.list) {
                PushProduct product = pushRecord.parsePushProduct();
                if (product == null) continue;
                this.productList.add(product);
            }
            if (this.sync && this.productList.size() > 0) {
                this.syncDataToLocal(this.productList);
            }
            this.processProductFileExist(this.getContext(), this.productList);
            this.parseLinkList(this.productList, parent.getCloudConf().getCloudStorage());
        }
    }

    private void syncDataToLocal(List<PushProduct> cloudList) {
        List<PushProduct> localList = this.loadLocalData();
        if (!CollectionUtils.isNullOrEmpty(localList)) {
            block0: for (PushProduct local : localList) {
                for (PushProduct cloud : cloudList) {
                    if (!StringUtils.isNotBlank((String)local.getGuid()) || !local.getGuid().equals(cloud.getGuid())) continue;
                    cloud.setIdString(local.getIdString());
                    continue block0;
                }
            }
        }
        StoreUtils.saveToLocal(cloudList, PushProduct.class, true);
    }

    private void processProductFileExist(Context context, List<PushProduct> list) {
        for (PushProduct product : list) {
            boolean result = false;
            Metadata meta = DataManagerHelper.getMetadataByCloudReference(context, product.getGuid());
            if (meta == null && StringUtils.isNotBlank((String)product.getIdString())) {
                meta = DataManagerHelper.getMetadataByHashTag(context, product.getIdString());
            }
            if (meta != null) {
                File file = new File(meta.getNativeAbsolutePath());
                result = file.exists();
            }
            product.isFiLeExist = result;
        }
    }

    private void parseLinkList(List<PushProduct> list, String cloudStorage) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        for (PushProduct product : list) {
            Link link = product.getFirstDownloadLink();
            if (link == null) {
                link = new Link();
            }
            this.linkList.add(link);
        }
    }

    private List<PushProduct> loadLocalData() {
        return StoreUtils.queryDataList(PushProduct.class, OrderBy.fromProperty(PushProduct_Table.createdAt).descending());
    }
}

