/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.model.PushBroadcast;
import com.onyx.android.sdk.data.model.PushBroadcast_Table;
import com.onyx.android.sdk.data.model.PushRecord;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Response;

public class PushBroadcastRequest
extends BaseCloudRequest {
    private boolean cloudOnly;
    private int queryOffset = 0;
    private int limit = 8;
    private List<PushRecord> recordList = new ArrayList<PushRecord>();
    private List<PushBroadcast> broadcastList = new ArrayList<PushBroadcast>();

    public PushBroadcastRequest(boolean cloud, int offset) {
        this.cloudOnly = cloud;
        this.queryOffset = offset;
    }

    public List<PushBroadcast> getBroadcastList() {
        return this.broadcastList;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (this.cloudOnly) {
            this.fetchFromCloud(parent);
            return;
        }
        this.fetchFromLocalCache(parent);
    }

    public void fetchFromLocalCache(CloudManager parent) throws Exception {
        List<PushBroadcast> list = this.fetchFromLocalCache(false, this.queryOffset, this.limit);
        int remain = this.limit - list.size();
        if (remain > 0) {
            list.addAll(this.fetchFromLocalCache(true, this.queryOffset, remain));
        }
        this.broadcastList = list;
    }

    private List<PushBroadcast> fetchFromLocalCache(boolean isReadCondition, int offset, int limit) {
        return SQLite.select((IProperty[])new IProperty[0]).from(PushBroadcast.class).where(new SQLCondition[]{PushBroadcast_Table.isReaded.is((Object)isReadCondition)}).orderBy(OrderBy.fromProperty(PushBroadcast_Table.createdAt).descending()).offset(offset).limit(limit).queryList();
    }

    public void fetchFromCloud(CloudManager parent) throws Exception {
        ProductResult result;
        Response<ProductResult<PushRecord>> response = this.executeCall(ServiceFactory.getPushService(parent.getCloudConf().getApiBase()).pushBroadcastList(this.getAccountSessionToken()));
        if (response.isSuccessful() && !StoreUtils.isEmpty(result = (ProductResult)response.body())) {
            this.recordList = result.list;
            for (PushRecord pushRecord : result.list) {
                PushBroadcast broadcast = pushRecord.parsePushBroadcast();
                if (broadcast == null) continue;
                this.broadcastList.add(broadcast);
            }
        }
    }
}

