/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.Category;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.v1.OnyxBookStoreService;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Response;

public class ContainerListRequest
extends BaseCloudRequest {
    private List<Category> containerList = new ArrayList<Category>();

    public final List<Category> getProductResult() {
        return this.containerList;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (CloudManager.isWifiConnected(this.getContext())) {
            this.fetchFromCloud(parent);
        } else {
            this.fetchFromLocalCache(parent);
        }
    }

    public void fetchFromCloud(CloudManager parent) throws Exception {
        OnyxBookStoreService service = ServiceFactory.getBookStoreService(parent.getCloudConf().getApiBase());
        Response<List<Category>> response = this.executeCall(service.bookContainerList());
        if (response.isSuccessful()) {
            this.containerList = (List)response.body();
            if (this.isSaveToLocal()) {
                this.saveToLocal(this.containerList);
            }
        }
    }

    public void fetchFromLocalCache(CloudManager parent) throws Exception {
        this.containerList = SQLite.select((IProperty[])new IProperty[0]).from(Category.class).queryList();
    }

    private void saveToLocal(List<Category> result) {
        StoreUtils.saveToLocalFast(result, Category.class, true);
    }
}

