/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.ApplicationUpdate;
import com.onyx.android.sdk.data.model.ProductQuery;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.v1.OnyxOTAService;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.CollectionUtils;
import java.util.List;
import retrofit2.Call;
import retrofit2.Response;

public class ApplicationUpdateRequest
extends BaseCloudRequest {
    private ProductQuery query;
    private List<ApplicationUpdate> queryList;
    private List<ApplicationUpdate> list;

    public ApplicationUpdateRequest(ProductQuery query) {
        this.query = query;
    }

    public ApplicationUpdateRequest(List<ApplicationUpdate> queryList) {
        this.queryList = queryList;
    }

    public List<ApplicationUpdate> getApplicationUpdateList() {
        return this.list;
    }

    public ApplicationUpdate getApplicationUpdate() {
        return CollectionUtils.isNullOrEmpty(this.list) ? null : this.list.get(0);
    }

    public List<ApplicationUpdate> getUpdateList() {
        return this.list;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        Response<List<ApplicationUpdate>> response = this.executeCall(this.call(ServiceFactory.getOTAService(parent.getCloudConf().getApiBase())));
        if (response.isSuccessful()) {
            this.list = (List)response.body();
        }
    }

    private Call<List<ApplicationUpdate>> call(OnyxOTAService service) {
        if (CollectionUtils.isNullOrEmpty(this.queryList)) {
            return service.getAllUpdateAppInfoList(JSON.toJSONString((Object)this.query));
        }
        return service.getUpdateAppInfoList(JSON.toJSONString(this.queryList));
    }
}

