/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class Device
extends BaseData {
    private static Device currentDevice;
    public int width;
    public int height;
    public String model;
    public String brand;
    public String system;
    public String channel;
    public String buildId;
    public String fingerprint;
    public Map<String, String> hwinfo;
    public String timezone;
    public String macAddress;
    public String accountId;
    public String deviceUniqueId;
    public Map<String, String> installationMap = new HashMap<String, String>();
    public String name;

    public static Device updateCurrentDeviceInfo(Context context) {
        if (currentDevice != null) {
            Device.updateDeviceUniqueId(context, currentDevice);
            return currentDevice;
        }
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (wifiManager == null || windowManager == null) {
            return null;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(metrics);
        currentDevice = new Device();
        Device.currentDevice.width = metrics.widthPixels;
        Device.currentDevice.height = metrics.heightPixels;
        Device.currentDevice.model = Build.MODEL;
        Device.currentDevice.brand = Build.BRAND;
        Device.currentDevice.fingerprint = Build.FINGERPRINT;
        Device.updateDeviceUniqueId(context, currentDevice);
        return currentDevice;
    }

    private static void updateDeviceUniqueId(Context context, Device device) {
        if (device == null) {
            return;
        }
        if (StringUtils.isNotBlank((String)device.macAddress) && StringUtils.isNotBlank((String)device.deviceUniqueId)) {
            return;
        }
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (wifiManager == null) {
            return;
        }
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        if (wifiInfo != null) {
            device.deviceUniqueId = device.macAddress = wifiInfo.getMacAddress();
        }
    }
}

